% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KinPairSimulation.R
\name{kin_pair_simulation}
\alias{kin_pair_simulation}
\title{KinPairSimulation}
\usage{
kin_pair_simulation(
  data = NULL,
  kinship = NULL,
  lifestage = NULL,
  simtype = NULL,
  kerneltype = NULL,
  posigma = NULL,
  initsigma = NULL,
  breedsigma = NULL,
  gravsigma = NULL,
  ovisigma = NULL,
  customsigma = NULL,
  simdims = NULL,
  kernelshape = NULL,
  cycle = NULL,
  call = NULL,
  filtertype = NULL,
  upper = NULL,
  lower = NULL,
  spacing = NULL,
  samplenum = NULL,
  sampledims = NULL,
  model = NULL
)
}
\arguments{
\item{data}{tbl_df. tibble  of simulation values}

\item{kinship}{character - one of PO, FS, HS, AV, HAV, GG, 1C, H1C, GAV, HGAV, 1C1, H1C1, GGG, 2C, and H2C.}

\item{lifestage}{character - one of 'unknown', 'immature' or 'ovipositional'}

\item{simtype}{character - simulation type}

\item{kerneltype}{character. - 'Gaussian', 'Laplace' or 'vgamma' (variance-gamma)}

\item{posigma}{numeric - overall value of dispersal sigma (for simple kernel)}

\item{initsigma}{numeric.    - value of pre-breeding dispersal sigma (for composite kernel)}

\item{breedsigma}{numeric.    - value of breeding dispersal sigma (for composite kernel)}

\item{gravsigma}{numeric.    - value of post-breeding dispersal sigma (for composite kernel)}

\item{ovisigma}{numeric.    - value of oviposition dispersal sigma (for composite kernel)}

\item{customsigma}{numeric. - vector of named custom dispersal sigmas (for custom kernel)}

\item{simdims}{numeric. - dimensions of sampling area (assumes one side of square)}

\item{kernelshape}{numeric. - value of kernel shape of simulation (if using kernel with shape parameter e.g. vgamma)}

\item{cycle}{integer - number of breeding cycles sampled individual has survived (for custom kernel)}

\item{call}{call. Call to create object}

\item{filtertype}{character. whether the initial sim has been further filtered}

\item{upper}{numeric.       - FILTER: upper threshold used}

\item{lower}{numeric.       - FILTER: lower threshold used}

\item{spacing}{numeric.       - FILTER: spacing used}

\item{samplenum}{numeric.       - FILTER: sample number used}

\item{sampledims}{numeric.       - FILTER: sample dimensions used}

\item{model}{list - model information if custom simulation used to generate object}
}
\value{
returns an object of class \code{KinPairSimulation}.
}
\description{
KinPairSimulation
}
\examples{
kin_pair_simulation()
}
