% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2-science.R
\name{scale_colour_stratigraphy}
\alias{scale_colour_stratigraphy}
\alias{scale_color_stratigraphy}
\alias{scale_fill_stratigraphy}
\title{Geologic Timescale Colour Scheme for ggplot2}
\usage{
scale_colour_stratigraphy(..., aesthetics = "colour")

scale_color_stratigraphy(..., aesthetics = "colour")

scale_fill_stratigraphy(..., aesthetics = "fill")
}
\arguments{
\item{...}{Arguments passed on to \code{\link[ggplot2]{discrete_scale}}.}

\item{aesthetics}{A \code{\link{character}} string or vector of character
strings listing the name(s) of the aesthetic(s) that this scale works with.}
}
\description{
Provides the geologic timescale colour scheme.
}
\details{
Values will be matched based on the unit names.
}
\examples{
library(ggplot2)

strati <- data.frame(
  name = c("Phanerozoic", "Paleozoic", "Cambrian", "Ordovician", "Silurian",
           "Devonian", "Carboniferous", "Mesozoic", "Triassic", "Cretaceous",
           "Jurassic", "Cenozoic", "Paleogene", "Neogene", "Quaternary"),
  type = c("Eon", "Era", "Period", "Period", "Period", "Period", "Period",
           "Era", "Period", "Period", "Period", "Era", "Period", "Period",
           "Period"),
  start = c(541, 541, 541, 485, 444, 419, 359,
            252, 252, 201, 145, 66, 66, 23, 2.6),
  end = c(0, 252, 485, 444, 419, 359, 252,
          66, 201, 145, 66, 2.6, 23, 2.6, 0)
)

ggplot(strati, aes(fill = name)) +
  geom_rect(aes(xmin = rep(0, 15), xmax = rep(1, 15),
                ymin = start, ymax = end)) +
  scale_y_reverse() + facet_grid(.~type) +
  scale_fill_stratigraphy(name = "Stratigraphy")
}
\references{
\href{https://www.ccgm.org}{Commission for the Geological Map of the World}
}
\seealso{
Other Themed colour schemes: \code{\link{scale_colour_soil}}
}
\author{
N. Frerebeau
}
\concept{Themed colour schemes}
