% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_analytics_by_level.R
\name{get_analytics_by_level}
\alias{get_analytics_by_level}
\title{Retrieves Analytics Table Data}
\usage{
get_analytics_by_level(
  element_ids,
  start_date,
  end_date = NULL,
  level = 1,
  org_ids = NULL,
  ...,
  call = caller_env()
)
}
\arguments{
\item{element_ids}{Required vector of data element IDs for which to retrieve data.}

\item{start_date}{Required start date to retrieve data. It is required and in the format \code{YYYY-MM-dd}.}

\item{end_date}{Optional ending date for data retrieval (default is the current date).}

\item{level}{The desired organisation level of data (default: level 1)}

\item{org_ids}{Optional list of organization units IDs to be filtered.}

\item{...}{Other options that can be passed onto DHIS2 API.}

\item{call}{The caller environment.}
}
\value{
A tibble with detailed information, including:
\itemize{
\item Geographical identifiers (country, subnational, district, facility, depending on level)
\item Reporting period (month, year, fiscal year)
\item Data element names
\item Category options
\item Reported values
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
\code{get_analytics_by_level()} fetches data from the DHIS2 analytics tables for a
given period and data element(s), without performing any aggregation.
}
\details{
\itemize{
\item Retrieves data directly from DHIS2 analytics tables.
\item Supports optional arguments for providing organization lists, data elements, and categories.
\item Allows specifying DHIS2 session objects, retry attempts, and logging verbosity.
}
}
\examples{
\dontshow{if (khis_has_cred()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Clinical Breast Examination data elements
# XEX93uLsAm2 = CBE Abnormal
# cXe64Yk0QMY = CBE Normal
element_id = c('cXe64Yk0QMY', 'XEX93uLsAm2')

# Download data from February 2023 to current date
data <- get_analytics_by_level(element_ids = element_id,
                               start_date = '2023-02-01')
data
\dontshow{\}) # examplesIf}
}
\seealso{
\itemize{
\item \code{\link[=get_organisations_by_level]{get_organisations_by_level()}} for getting the organisations units
\item \code{\link[=get_data_elements_with_category_options]{get_data_elements_with_category_options()}} for retrieving the data elements
}
}
