% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytics-dimension.R
\name{analytics-dimension}
\alias{analytics-dimension}
\alias{analytics_dimension}
\alias{\%.d\%}
\alias{\%.f\%}
\title{Analytics Data Dimensions}
\usage{
analytics_dimension(property, operator, values)

operator \%.d\% values

operator \%.f\% values
}
\arguments{
\item{property}{A character string representing whether its dimension or filter.
It only accepts \code{'dimension'}, \code{'filter'}.}

\item{operator}{A character string representing the property to filter on (e.g.,
\code{'dx'}, \code{'pe'}, \code{'ou'}).}

\item{values}{A vector of values or semi-colon separated string items.}
}
\value{
A spliced list with filter in the format property=operator:value
}
\description{
Constructs a dimensions expression for analytics queries based on specified
property, operator, and values.
}
\details{
DHIS2 organizes data using multiple dimensions, each with a unique identifier
and a set of items that represent specific data points within that dimension.
\itemize{
\item Data elements (dx): Indicators, data set reporting rate metrics, data element
operands, program indicators, program data elements, program attributes,
validation rules.
\item Periods (pe): ISO periods (e.g., 202401) and relative periods (e.g., LAST_WEEK).
\item Organisation unit hierarchy (ou): Specific health facilities, districts, countries,
and keywords for user location or its sub-units.
\item Category option combinations (co): Category option combo identifiers.
\item Attribute option combinations (ao): Category option combo identifiers.
\item Categories: Category option identifiers.
\item Data element group sets: Data element group identifiers.
\item Organisation unit group sets: Organisation unit group identifiers.
}

The infix operator used for filter and dimension includes:
\itemize{
\item \verb{\%.d\%}: Infix operator for constructing dimension filters. Equivalent to
calling \code{analytics_dimension("dimension", ...)}.
\item \verb{\%.f\%}: Infix operator for constructing filter filters. Equivalent to calling
\code{analytics_dimension("filter", ...)}.
}
}
\examples{

# Create a dimension for data element "DE_1234"
analytics_dimension('dimension', "dx", "DE_1234")

# Equivalent to the expression above
dx \%.d\% "DE_1234"

# Create a filter dimension for the period of January 2024
pe \%.f\% "202401"

# Create filter dimension for periods "202401" and "202402":
analytics_dimension("filter", "pe", c("202401", "202402"))

}
