% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/keyplayer.R
\name{delta.score}
\alias{delta.score}
\title{The change on objective function for greedy search implimentation}
\usage{
delta.score(adj.matrix, candidate, residual, i, j, type, M = Inf,
  T = ncol(adj.matrix), method, binary = FALSE, cmode)
}
\arguments{
\item{adj.matrix}{The adjacency matrix of the network. Input the matrix.}

\item{candidate}{A specified set of players which centrality is measured.}

\item{residual}{A specified set of players which the member can replace the
member in the candidate set.}

\item{i}{The specific member in candidate set to be replaced}

\item{j}{The specific member in residual set to replace \code{i} in candidate set}

\item{type}{Choose
\code{type="betweenness"} for betweenness centrality,
\code{type="closeness"} for closeness centrality,
\code{type="degree"} for degree centraslity,
\code{type="diffusion"} for diffusion centrality.
\code{type="evcent"} for eigenvector centrality,
\code{type="fragment"} for fragmentation centrality,
\code{type="mreach.degree"} for mreach.degree centrality, and
\code{type="mreach.closeness"} for mreach.closeness centrality.}

\item{M}{Positive number indicating the maximum distance between two nodes,
above witch the two nodes are considered disconnected. The default is
\code{Inf}.
The option is applicable to mreach.degree, mreach.closeness, fragmentation,
and diffusion centralities.}

\item{T}{Integer indicating the maximum number of iterations
of communication process. For diffusion centrality only.
In the first iteration, the adjacency matrix
is as the input. In the nth iteration, the adjacency matrix becomes
the input adjacency matrix to the power of n. By default, T is the network size.}

\item{method}{Indication of which grouping criterion should be used.
\code{method="min"} indicates the "minimum" criterion (edge values as distances).
\code{method="max"} indicates the "maximum" criterion (edge values as non-cummulative strengths).
\code{method="add"} indicates the "addition" criterion (edge values as cummulative strengths).
\code{method="union"} indicates the "union" criterion (edge values as probability).
By default, the minimun criterion is used for betweenness, closeness, fragmentation,
mreach.degree, and mreach.closeness centralities.
The maximun criterion is used for degree and eigenvector centralities.
The union criterion is used for diffusion centrality.}

\item{binary}{If \code{TRUE}, the adjacency matrix is binarized.
If \code{FALSE}, the edge values are considered. By default, \code{binary=FALSE}}

\item{cmode}{String indicating the type of centrality being evaluated.
The option is applicable to degree, mreach.degree, and mreach.closeness centralities.
The default is to report the total degree.
\code{cmode="outdegree"} and \code{cmode="indegree"} refer to indegree and outdegree
respectively. If \code{cmode="all"}, all the three types are reported.
The option can also applicable to closeness centrality.
See \code{\link[sna]{closeness}} Details section.
The default is to use the Gil-Schmidt power index.}
}
\value{
The change on kp score
}
\description{
\code{delta.score} calculates the base kp score using \code{kpcent} with
the specified chosen set of players called candidate. Then the function
replaces a player from another specified set of plyers called residual and
calculates the new kp score. The function finally reports the difference of
the two scores.
}
\keyword{internal}

