% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_timetrend}
\alias{plot_timetrend}
\title{Plot time trend}
\usage{
plot_timetrend(
  x,
  show_topic = NULL,
  time_index_label = NULL,
  ci = 0.9,
  method = c("hdi", "eti"),
  point = c("mean", "median"),
  xlab = "Time",
  scales = "fixed",
  show_point = TRUE,
  ...
)
}
\arguments{
\item{x}{the output from the dynamic keyATM model (see \code{\link[=keyATM]{keyATM()}}).}

\item{show_topic}{an integer or a vector. Indicate topics to visualize. Default is \code{NULL}.}

\item{time_index_label}{a vector. The label for time index. The length should be equal to the number of documents (time index provided to \code{\link[=keyATM]{keyATM()}}).}

\item{ci}{value of the credible interval (between 0 and 1) to be estimated. Default is \code{0.9} (90\%). This is an option when calculating credible intervals (you need to set \code{store_theta = TRUE} in \code{\link[=keyATM]{keyATM()}}).}

\item{method}{method for computing the credible interval. The Highest Density Interval (\code{hdi}, default) or Equal-tailed Interval (\code{eti}). This is an option when calculating credible intervals (you need to set \code{store_theta = TRUE} in \code{\link[=keyATM]{keyATM()}}).}

\item{point}{method for computing the point estimate. \code{mean} (default) or \code{median}. This is an option when calculating credible intervals (you need to set \code{store_theta = TRUE} in \code{\link[=keyATM]{keyATM()}}).}

\item{xlab}{a character.}

\item{scales}{character. Control the scale of y-axis (the parameter in \link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}): \code{free} adjusts y-axis for parameters. Default is \code{fixed}.}

\item{show_point}{logical. The default is \code{TRUE}. This is an option when calculating credible intervals.}

\item{...}{additional arguments not used.}
}
\value{
keyATM_fig object.
}
\description{
Plot time trend
}
\seealso{
\code{\link[=save_fig]{save_fig()}}
}
