% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.R
\name{random_binomial}
\alias{random_binomial}
\title{Draw samples from a Binomial distribution.}
\usage{
random_binomial(shape, counts, probabilities, dtype = NULL, seed = NULL)
}
\arguments{
\item{shape}{The shape of the random values to generate.}

\item{counts}{A number or array of numbers representing the
number of trials. It must be broadcastable with \code{probabilities}.}

\item{probabilities}{A float or array of floats representing the
probability of success of an individual event.
It must be broadcastable with \code{counts}.}

\item{dtype}{Optional dtype of the tensor. Only floating point types are
supported. If not specified, \code{config_floatx()} is used,
which defaults to \code{"float32"} unless you configured it otherwise (via
\code{config_set_floatx(float_dtype)}).}

\item{seed}{A Python integer or instance of
\code{random_seed_generator()}.
Used to make the behavior of the initializer
deterministic. Note that an initializer seeded with an integer
or None (unseeded) will produce the same random values
across multiple calls. To get different random values
across multiple calls, use as seed an instance
of \code{random_seed_generator()}.}
}
\value{
A tensor of random values.
}
\description{
The values are drawn from a Binomial distribution with
specified trial count and probability of success.
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/random/binomial}
}

Other random: \cr
\code{\link{random_beta}()} \cr
\code{\link{random_categorical}()} \cr
\code{\link{random_dropout}()} \cr
\code{\link{random_gamma}()} \cr
\code{\link{random_integer}()} \cr
\code{\link{random_normal}()} \cr
\code{\link{random_seed_generator}()} \cr
\code{\link{random_shuffle}()} \cr
\code{\link{random_truncated_normal}()} \cr
\code{\link{random_uniform}()} \cr
}
\concept{random}
