% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-core.R
\name{layer_input}
\alias{layer_input}
\title{Input layer}
\usage{
layer_input(
  shape = NULL,
  batch_shape = NULL,
  name = NULL,
  dtype = NULL,
  sparse = FALSE,
  tensor = NULL,
  ragged = FALSE
)
}
\arguments{
\item{shape}{Shape, not including the batch size. For instance,
\code{shape=c(32)} indicates that the expected input will be batches
of 32-dimensional vectors.}

\item{batch_shape}{Shape, including the batch size. For instance,
\code{shape = c(10,32)} indicates that the expected input will be batches
of 10 32-dimensional vectors. \code{batch_shape = list(NULL, 32)} indicates
batches of an arbitrary number of 32-dimensional vectors.}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{dtype}{The data type expected by the input, as a string (\code{float32},
\code{float64}, \code{int32}...)}

\item{sparse}{Boolean, whether the placeholder created is meant to be sparse.}

\item{tensor}{Existing tensor to wrap into the \code{Input} layer. If set, the
layer will not create a placeholder tensor.}

\item{ragged}{A boolean specifying whether the placeholder to be created is
ragged. Only one of 'ragged' and 'sparse' can be \code{TRUE} In this case, values
of 'NULL' in the 'shape' argument represent ragged dimensions.}
}
\value{
A tensor
}
\description{
Layer to be used as an entry point into a graph.
}
\seealso{
Other core layers: 
\code{\link{layer_activation}()},
\code{\link{layer_activity_regularization}()},
\code{\link{layer_attention}()},
\code{\link{layer_dense_features}()},
\code{\link{layer_dense}()},
\code{\link{layer_dropout}()},
\code{\link{layer_flatten}()},
\code{\link{layer_lambda}()},
\code{\link{layer_masking}()},
\code{\link{layer_permute}()},
\code{\link{layer_repeat_vector}()},
\code{\link{layer_reshape}()}
}
\concept{core layers}
