% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{compile.keras.engine.training.Model}
\alias{compile.keras.engine.training.Model}
\title{Configure a Keras model for training}
\usage{
\method{compile}{keras.engine.training.Model}(object, optimizer, loss,
  metrics = NULL, loss_weights = NULL, sample_weight_mode = NULL,
  weighted_metrics = NULL, target_tensors = NULL, ...)
}
\arguments{
\item{object}{Model object to compile.}

\item{optimizer}{Name of optimizer or optimizer instance.}

\item{loss}{Name of objective function or objective function. If the model
has multiple outputs, you can use a different loss on each output by
passing a dictionary or a list of objectives. The loss value that will be
minimized by the model will then be the sum of all individual losses.}

\item{metrics}{List of metrics to be evaluated by the model during training
and testing. Typically you will use \code{metrics='accuracy'}. To specify
different metrics for different outputs of a multi-output model, you could
also pass a named list such as \code{metrics=list(output_a = 'accuracy')}.}

\item{loss_weights}{Optional list specifying scalar coefficients to weight
the loss contributions of different model outputs. The loss value that will
be minimized by the model will then be the \emph{weighted sum} of all indvidual
losses, weighted by the \code{loss_weights} coefficients.}

\item{sample_weight_mode}{If you need to do timestep-wise sample weighting
(2D weights), set this to "temporal". \code{NULL} defaults to sample-wise
weights (1D). If the model has multiple outputs, you can use a different
\code{sample_weight_mode} on each output by passing a list of modes.}

\item{weighted_metrics}{List of metrics to be evaluated and weighted
by sample_weight or class_weight during training and testing}

\item{target_tensors}{By default, Keras will create a placeholder for the
model's target, which will be fed with the target data during
training. If instead you would like to use your own
target tensor (in turn, Keras will not expect external
data for these targets at training time), you
can specify them via the \code{target_tensors} argument. It should be
a single tensor (for a single-output sequential model),}

\item{...}{When using the Theano/CNTK backends, these arguments
are passed into K.function. When using the TensorFlow backend,
these arguments are passed into \code{tf$Session()$run}.}
}
\description{
Configure a Keras model for training
}
\seealso{
Other model functions: \code{\link{evaluate.keras.engine.training.Model}},
  \code{\link{evaluate_generator}},
  \code{\link{fit.keras.engine.training.Model}},
  \code{\link{fit_generator}}, \code{\link{get_config}},
  \code{\link{get_layer}},
  \code{\link{keras_model_sequential}},
  \code{\link{keras_model}}, \code{\link{multi_gpu_model}},
  \code{\link{pop_layer}},
  \code{\link{predict.keras.engine.training.Model}},
  \code{\link{predict_generator}},
  \code{\link{predict_on_batch}},
  \code{\link{predict_proba}},
  \code{\link{summary.keras.engine.training.Model}},
  \code{\link{train_on_batch}}
}
\concept{model functions}
