% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kdtools.R
\name{kd_lower_bound}
\alias{kd_lower_bound}
\alias{kd_upper_bound}
\alias{kd_range_query}
\alias{kd_rq_indices}
\alias{kd_binary_search}
\title{Search sorted data}
\usage{
kd_lower_bound(x, v)

kd_upper_bound(x, v)

kd_range_query(x, l, u)

kd_rq_indices(x, l, u)

kd_binary_search(x, v)
}
\arguments{
\item{x}{an object sorted by \code{\link{kd_sort}}}

\item{v}{a vector specifying where to look}

\item{l}{lower left corner of search region}

\item{u}{upper right corner of search region}
}
\description{
Search sorted data
}
\examples{
x = matrix(runif(200), 100)
y = matrix_to_tuples(x)
kd_sort(y, inplace = TRUE)
y[kd_lower_bound(y, c(1/2, 1/2)),]
y[kd_upper_bound(y, c(1/2, 1/2)),]
kd_binary_search(y, c(1/2, 1/2))
kd_range_query(y, c(1/3, 1/3), c(2/3, 2/3))
kd_rq_indices(y, c(1/3, 1/3), c(2/3, 2/3))

}
