% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dep_measures.R
\name{dep_measures}
\alias{dep_measures}
\title{Dependence measures of a \code{kdecop()} fit}
\usage{
dep_measures(object, measures = "all", n_qmc = 10^3, seed = 5)
}
\arguments{
\item{object}{an object of class \code{kdecopula}.}

\item{measures}{which measures to compute, see \emph{Details}.}

\item{n_qmc}{the number of quasi Monte Carlo samples.}

\item{seed}{the seed for quasi Monte Carlo integration.}
}
\value{
A named vector of dependence measures.

The following measures are available:
\describe{
\item{\code{"kendall"}}{Kendall's \eqn{\tau}, see Nelsen (2007); computed as the
sample version of a quasi Monte Carlo sample.}
\item{\code{"spearman"}}{Spearman's \eqn{\rho}, see Nelsen (2007); computed as the
sample version of a quasi Monte Carlo sample.}
\item{\code{"blomqvist"}}{Blomqvist's \eqn{\beta}, see Nelsen (2007); computed
as \eqn{4C(0.5, 0.5) - 1}.}
\item{\code{"gini"}}{Gini's \eqn{\gamma}, see Nelsen (2007); computed by quasi
Monte Carlo integration.}
\item{\code{"vd_waerden"}}{van der Waerden's coefficient, see Genest and Verret
(2005); computed as the sample version of a quasi Monte Carlo sample.}
\item{\code{"minfo"}}{mutual information, see Joe (1989); computed by quasi Monte
Carlo integration.}
\item{\code{"linfoot"}}{Linfoot's correlation coefficient, see Joe (1989);
computed by quasi Monte Carlo integration.}
}
}
\description{
Calculates several dependence measures derived from the copula density. All
measures except \code{"blomqvist"} are computed by quasi Monte Carlo methods
(see \code{\link[=rkdecop]{rkdecop()}}.
}
\examples{
## load data and transform with empirical cdf
data(wdbc)
udat <- apply(wdbc[, -1], 2, function(x) rank(x) / (length(x) + 1))

## estimate copula density and calculate dependence measures
fit <- kdecop(udat[, 5:6])
dep_measures(fit)

}
\references{
Nelsen, R. (2007). An introduction to copulas. Springer Science
& Business Media, 2007.

Genest, C., and Verret, F. (2005). Locally most powerful rank tests of
independence for copula models. Journal of Nonparametric Statistics, 17(5)

Joe, H. (1989). Relative Entropy Measures of Multivariate Dependence.
Journal of the American Statistical Association, 84(405)
}
