% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/katex.R
\name{katex}
\alias{katex}
\alias{katex_html}
\alias{katex_mathml}
\alias{example_math}
\title{Tex math rendering in R}
\usage{
katex_html(
  tex,
  displayMode = TRUE,
  ...,
  include_css = FALSE,
  preview = interactive()
)

katex_mathml(tex, displayMode = TRUE, ...)

example_math()
}
\arguments{
\item{tex}{input string with tex math expression.}

\item{displayMode}{render math in centered 2D layout, similar to \verb{$$} in tex.
Set to \code{FALSE} to render (non-centered) inline layout for use in text.
For pdf output, this corresponds to the \verb{\deqn{}} and \verb{\eqn{}} macros, see
\href{https://cran.r-project.org/doc/manuals/r-release/R-exts.html#Mathematics}{WRE 2.6: Mathematics}}

\item{...}{additional html rendering options passed to
\href{https://katex.org/docs/options.html}{katex.render}}

\item{include_css}{adds the katex css file to the output.
This is only required once per html webpage. Set to \code{FALSE} if you include css
files into the your html head some other way.}

\item{preview}{open an HTML preview page showing the snipped in the browser}
}
\value{
a string with a html/mathml fragment
}
\description{
Converts tex-style math expressions to html and mathml for use in manual pages or
markdown documents.
The conversion is done in R using V8 ("server-side"), hence the resulting fragment can
be inserted into an HTML document without the need for a JavaScript library like MathJax.
Only the \href{https://cdn.jsdelivr.net/npm/katex@0.13.11/dist/katex.min.css}{katex.css}
style file is required in the final html document.
Use \link{math_to_rd} for embedding math into R documentation (\code{.rd}) pages.
}
\details{
Refer to the upstream \href{https://katex.org/docs/support_table.html}{katex support table} for
the full list of supported tex functions that can be rendered to html using katex.

By default, \link{katex_html} returns a mix of HTML for visual rendering and includes
MathML for accessibility. To only get html, pass \code{output="html"} in the extra options,
see also the \href{https://katex.org/docs/options.html}{katex documentation}.
}
\examples{
# Basic examples
html <- katex_html(example_math())
mathml <- katex_mathml(example_math())

# Example from katex.org homepage:
macros <- list("\\\\f" = "#1f(#2)")
math <- "\\\\f\\\\relax{x} = \\\\int_{-\\\\infty}^\\\\infty \\\\f\\\\hat\\\\xi\\\\,e^{2 \\\\pi i \\\\xi x} \\\\,d\\\\xi"
html <- katex_html(math,  macros = macros)
mathml <- katex_mathml(math,  macros = macros)
}
\seealso{
Other katex: 
\code{\link{math_to_rd}()},
\code{\link{pandoc}}
}
\concept{katex}
