% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/seriation_assess.R
\docType{methods}
\name{assess}
\alias{assess}
\alias{assess-method}
\alias{assess,AveragePermutationOrder-method}
\title{Statistical Significance of Seriation Solutions}
\usage{
assess(object, ...)

\S4method{assess}{AveragePermutationOrder}(object, axes = 1, n = 1000, progress = getOption("kairos.progress"))
}
\arguments{
\item{object}{A \code{\linkS4class{PermutationOrder}} object giving the permutation
order for rows and columns (typically returned by \code{\link[=seriate_average]{seriate_average()}}).}

\item{...}{Currently not used.}

\item{axes}{An \code{\link{integer}} vector giving the subscripts of the CA axes to be
used.}

\item{n}{A non-negative \code{\link{integer}} giving the number of bootstrap
replications.}

\item{progress}{A \code{\link{logical}} scalar: should a progress bar be displayed?}
}
\value{
A \code{\link{list}} with the following elements:
\describe{
\item{\code{random}}{A \code{\link{numeric}} vector giving the randomized total number of
modes values.}
\item{\code{observed}}{A \code{\link{numeric}} value giving the observed total number of
modes.}
\item{\code{expected}}{A \code{\link{numeric}} value giving the expected total number of
modes if all types had unimodal distributions.}
\item{\code{maximum}}{A \code{\link{numeric}} value giving the maximum total number of
modes.}
\item{\code{coef}}{A \code{\link{numeric}} value giving the seriation coefficient (a value
close to 1 indicates a strong fit to the seriation model, while a value
close to 0 indicates a poor fit).}
}
}
\description{
Tests the significance of seriation solutions.
}
\examples{
\dontrun{
## Data from Desachy 2004
data("compiegne", package = "folio")

## Correspondance analysis based seriation
(indices <- seriate_average(compiegne, margin = c(1, 2), axes = 1))

## Test significance of seriation results
## Warning: this may take a few seconds!
signif <- assess(indices, axes = 1, n = 1000)

## Histogram of randomized total number of modes
hist(signif$random)

## Observed value is smaller than the 5th percentile of the
## distribution of randomized samples
quantile(signif$random, probs = 0.05)
signif$observed

## Seriation coefficient
## (close to 1: relatively strong and significant signal of unimodality)
signif$coef
}
}
\references{
Porčić, M. (2013). The Goodness of Fit and Statistical Significance of
Seriation Solutions. \emph{Journal of Archaeological Science}, 40(12): 4552-4559.
\doi{10.1016/j.jas.2013.07.013}.
}
\seealso{
Other seriation methods: 
\code{\link{as_seriation}()},
\code{\link{order}()},
\code{\link{permute}()},
\code{\link{refine}()},
\code{\link{seriate_average}()},
\code{\link{seriate_rank}()}
}
\author{
N. Frerebeau
}
\concept{seriation methods}
