% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mini_plots.R
\name{spec_hist}
\alias{spec_hist}
\alias{spec_boxplot}
\title{Helper functions to generate inline sparklines}
\usage{
spec_hist(
  x,
  width = 200,
  height = 50,
  res = 300,
  breaks = "Sturges",
  same_lim = TRUE,
  lim = NULL,
  xaxt = "n",
  yaxt = "n",
  ann = FALSE,
  col = "lightgray",
  border = NULL,
  dir = if (is_latex()) rmd_files_dir() else tempdir(),
  file = NULL,
  file_type = if (is_latex()) "png" else "svg",
  ...
)

spec_boxplot(
  x,
  width = 200,
  height = 50,
  res = 300,
  add_label = FALSE,
  label_digits = 2,
  same_lim = TRUE,
  lim = NULL,
  xaxt = "n",
  yaxt = "n",
  ann = FALSE,
  col = "lightgray",
  border = NULL,
  boxlty = 0,
  medcol = "red",
  medlwd = 1,
  dir = if (is_latex()) rmd_files_dir() else tempdir(),
  file = NULL,
  file_type = if (is_latex()) "png" else "svg",
  ...
)
}
\arguments{
\item{x}{Vector of values or List of vectors of values.}

\item{width}{The width of the plot in pixel}

\item{height}{The height of the plot in pixel}

\item{res}{The resolution of the plot. Default is 300.}

\item{breaks}{one of:
    \itemize{
      \item a vector giving the breakpoints between histogram cells,
      \item a function to compute the vector of breakpoints,
      \item a single number giving the number of cells for the histogram,
      \item a character string naming an algorithm to compute the
      number of cells (see \sQuote{Details}),
      \item a function to compute the number of cells.
    }
    In the last three cases the number is a suggestion only; as the
    breakpoints will be set to \code{\link{pretty}} values, the number
    is limited to \code{1e6} (with a warning if it was larger).  If
    \code{breaks} is a function, the \code{x} vector is supplied to it
    as the only argument (and the number of breaks is only limited by
    the amount of available memory).
  }

\item{same_lim}{T/F. If x is a list of vectors, should all the plots be
plotted in the same range? Default is True.}

\item{lim}{Manually specify plotting range in the form of \code{c(0, 10)}.}

\item{xaxt}{On/Off for xaxis text}

\item{yaxt}{On/Off for yaxis text}

\item{ann}{On/Off for annotations (titles and axis titles)}

\item{col}{Color for the fill of the histogram bar/boxplot box.}

\item{border}{Color for the border.}

\item{dir}{Directory of where the images will be saved.}

\item{file}{File name. If not provided, a random name will be used}

\item{file_type}{Graphic device. Support \code{png} or \code{svg}. SVG is recommended
for HTML output}

\item{...}{further arguments and \link[graphics]{graphical parameters} passed to
    \code{\link[graphics]{plot.histogram}} and thence to \code{\link[graphics]{title}} and
    \code{\link[graphics]{axis}} (if \code{plot = TRUE}).}

\item{add_label}{For boxplot. T/F to add labels for min, mean and max.}

\item{label_digits}{If T for add_label, rounding digits for the label.
Default is 2.}

\item{boxlty}{Boxplot - box boarder type}

\item{medcol}{Boxplot - median line color}

\item{medlwd}{Boxplot - median line width}
}
\description{
These functions helps you quickly generate sets of sparkline
style plots using base R plotting system. Currently, we support histogram
and boxplot. You can use them together with \code{column_spec} to
generate inline plot in tables. By default, this function will save images
in a folder called "kableExtra" and return the address of the file.
}
