% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse_rows.R
\name{collapse_rows}
\alias{collapse_rows}
\title{Collapse repeated rows to multirow cell}
\usage{
collapse_rows(kable_input, columns = NULL, valign = c("middle", "top",
  "bottom"), latex_hline = c("full", "major", "none", "custom"),
  row_group_label_position = c("identity", "stack"),
  custom_latex_hline = NULL, row_group_label_fonts = NULL,
  headers_to_remove = NULL)
}
\arguments{
\item{kable_input}{Output of \code{knitr::kable()} with \code{format} specified}

\item{columns}{A numeric value or vector indicating in which column(s) rows
need to be collapsed.}

\item{valign}{Select from "top", "middle"(default), "bottom". The reason why
"top" is not default is that the multirow package on CRAN win-builder is
not up to date.}

\item{latex_hline}{Option controlling the behavior of adding hlines to table.
Choose from \code{full}, \code{major}, \code{none}, \code{custom}.}

\item{row_group_label_position}{Option controlling positions of row group
labels. Choose from \code{identity}, \code{stack}.}

\item{custom_latex_hline}{Numeric column positions whose collapsed rows will
be separated by hlines.}

\item{row_group_label_fonts}{A list of arguments that can be supplied to
group_rows function to format the row group label when
\code{row_group_label_position} is \code{stack}}

\item{headers_to_remove}{Numeric column positions where headers should be
removed when they are stacked.}
}
\description{
Collapse same values in columns into multirow cells. This
feature does similar things with \code{group_rows}. However, unlike \code{group_rows},
it analyzes existing columns, finds out rows that can be grouped together,
and make them multirow cells. Note that if you want to use \code{column_spec} to
specify column styles, you should use \code{column_spec} before \code{collapse_rows}.
}
\examples{
dt <- data.frame(a = c(1, 1, 2, 2), b = c("a", "a", "a", "b"))
x <- knitr::kable(dt, "html")
collapse_rows(x)

}
