% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.r
\name{fix_na_ish}
\alias{fix_na_ish}
\title{Fix NA-like strings to be NA (or other value of choice)}
\usage{
fix_na_ish(x, extra_na = NULL, new_val = NA)
}
\arguments{
\item{x}{data frame}

\item{extra_na}{Additional values to consider equivalent to NA}

\item{new_val}{New value to be used instead of NA-ish values, default is \code{NA}}
}
\description{
Fix NA-like strings to be NA (or other value of choice)
}
\examples{
df <- data.frame(
  a = c("NA", "n/a", 1, NA),
  b = c("three", "na", NaN, "  N/A "),
  stringsAsFactors = FALSE
)
df
fix_na_ish(df)
fix_na_ish(df, extra_na = "three", new_val = "0")
}
