% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number_of_junctions_backcross.R
\name{number_of_junctions_backcross}
\alias{number_of_junctions_backcross}
\title{Calculate the average number of junctions during backcrossing}
\usage{
number_of_junctions_backcross(H_0 = 0.5, C = 1, t = 100)
}
\arguments{
\item{H_0}{Frequency of heterozygosity at t = 0}

\item{C}{Mean number of crossovers per meiosis (e.g. size in Morgan of the
chromosome)}

\item{t}{Time since admixture}
}
\value{
Estimated number of junctions at time t
}
\description{
Calculate the expected number of junctions after t
generations, in a backcrossing mating scheme.
}
\examples{
cat("example number of junctions backcross")
jt <-  number_of_junctions_backcross(H_0 = 0.1, C = 1, t = 5)
}
