% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_triang.R
\name{triangulate}
\alias{triangulate}
\alias{triangulate.cpt_list}
\title{Triangulate a Bayesian network}
\usage{
triangulate(
  x,
  root_node = "",
  joint_vars = NULL,
  tri = "min_fill",
  pmf_evidence = NULL,
  alpha = NULL,
  perm = FALSE,
  mpd_based = FALSE
)

\method{triangulate}{cpt_list}(
  x,
  root_node = "",
  joint_vars = NULL,
  tri = "min_fill",
  pmf_evidence = NULL,
  alpha = NULL,
  perm = FALSE,
  mpd_based = FALSE
)
}
\arguments{
\item{x}{An object returned from \code{cpt_list} (baeysian network) or
\code{pot_list} (decomposable markov random field)}

\item{root_node}{A node for which we require it to live in the root
clique (the first clique).}

\item{joint_vars}{A vector of variables for which we require them
to be in the same clique. Edges between all these variables are added
to the moralized graph.}

\item{tri}{The optimization strategy used for triangulation if x originates
from a Baeysian network. One of
\itemize{
\item 'min_fill'
\item 'min_rfill'
\item 'min_sp'
\item 'min_ssp'
\item 'min_lsp'
\item 'min_lssp'
\item 'min_elsp'
\item 'min_elssp'
\item 'min_nei'
\item 'minimal'
\item 'alpha'
}}

\item{pmf_evidence}{A named vector of frequencies of the expected
missingness of a variable. Variables with frequencies of 1 can be
neglected; these are inferrred. A value of 0.25 means, that the
given variable is expected to be missing (it is not a evidence node)
in one fourth of the future cases. Relevant for \code{tri} methods
'min_elsp' and 'min_elssp'.}

\item{alpha}{Character vector. A permutation of the nodes
in the graph. It specifies a user-supplied eliminination ordering for
triangulation of the moral graph.}

\item{perm}{Logical. If \code{TRUE} the moral graph is permuted}

\item{mpd_based}{Logical. True if the triangulation should be performed on a maximal
peime decomposition}
}
\description{
Given a list of CPTs, this function finds a triangulation
}
