% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_json.R
\name{to_json}
\alias{to_json}
\alias{to_json.data.frame}
\alias{to_json.numeric}
\alias{to_json.character}
\alias{to_json.integer}
\alias{to_json.logical}
\alias{to_json.complex}
\alias{to_json.matrix}
\alias{to_json.Date}
\alias{to_json.POSIXct}
\alias{to_json.POSIXlt}
\alias{to_json.list}
\alias{to_json.default}
\title{To JSON}
\usage{
to_json(x, ...)

\method{to_json}{data.frame}(x, ..., numeric_dates = TRUE)

\method{to_json}{numeric}(x, ...)

\method{to_json}{character}(x, ...)

\method{to_json}{integer}(x, ...)

\method{to_json}{logical}(x, ...)

\method{to_json}{complex}(x, ...)

\method{to_json}{matrix}(x, ...)

\method{to_json}{Date}(x, ..., numeric_dates = TRUE)

\method{to_json}{POSIXct}(x, ..., numeric_dates = TRUE)

\method{to_json}{POSIXlt}(x, ..., numeric_dates = TRUE)

\method{to_json}{list}(x, ...)

\method{to_json}{default}(x, ...)
}
\arguments{
\item{x}{object to convert to JSON}

\item{...}{arguments passed to other methods}

\item{numeric_dates}{logical indicating if dates should be treated as numerics. 
Defaults to TRUE for speed. If FALSE, the dates will be coerced to character}
}
\description{
Converts R objects to JSON
}
\examples{

to_json(1:3)
to_json(letters[1:3])
to_json(data.frame(x = 1:3, y = letters[1:3]))
to_json(list(x = 1:3, y = list(z = letters[1:3])))
to_json(seq(as.Date("2018-01-01"), as.Date("2018-01-05"), length.out = 5))
to_json(seq(as.Date("2018-01-01"), as.Date("2018-01-05"), length.out = 5), numeric_dates = FALSE)

}
