% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tb1.R
\name{tb1module2}
\alias{tb1module2}
\title{tb1module2: table 1 shiny module server for reactive data.}
\usage{
tb1module2(
  input,
  output,
  session,
  data,
  data_label,
  data_varStruct = NULL,
  nfactor.limit = 10,
  design.survey = NULL,
  showAllLevels = T,
  argsExact = list(workspace = 2 * 10^7, simulate.p.value = T)
)
}
\arguments{
\item{input}{input}

\item{output}{output}

\item{session}{session}

\item{data}{Reactive data}

\item{data_label}{Reactive data label}

\item{data_varStruct}{Variable structure list of data, Default: NULL}

\item{nfactor.limit}{maximum factor levels to include, Default: 10}

\item{design.survey}{Reactive survey data of survey package. Default: NULL}

\item{showAllLevels}{Show All label information with 2 categorical variables, Default: T}

\item{argsExact}{Option for Fisher exact test memory limit.}
}
\value{
Table 1 shiny module server for descriptive statistics.
}
\description{
Table 1 shiny module server for descriptive statistics for reactive data.
}
\details{
Table 1 shiny module server for descriptive statistics.
}
\examples{
library(shiny)
library(DT)
library(data.table)
library(jstable)
ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      tb1moduleUI("tb1")
    ),
    mainPanel(
      DTOutput("table1")
    )
  )
)

server <- function(input, output, session) {
  data <- reactive(mtcars)
  data.label <- reactive(jstable::mk.lev(mtcars))

  out_tb1 <- callModule(tb1module2, "tb1",
    data = data, data_label = data.label,
    data_varStruct = NULL
  )

  output$table1 <- renderDT({
    tb <- out_tb1()$table
    cap <- out_tb1()$caption
    out.tb1 <- datatable(tb, rownames = T, extension = "Buttons", caption = cap)
    return(out.tb1)
  })
}
}
