% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrSiCKLSNMF.R
\name{ClusterSickleJr}
\alias{ClusterSickleJr}
\title{Cluster the \eqn{\mathbf{H}} matrix}
\usage{
ClusterSickleJr(
  SickleJr,
  numclusts,
  method = "kmeans",
  neighbors = 20,
  louvainres = 0.3
)
}
\arguments{
\item{SickleJr}{An object of class SickleJr}

\item{numclusts}{Number of clusters; can be NULL when method is "max" or "louvain"}

\item{method}{String holding the clustering method: can choose "kmeans" for
k-means clustering, "spectral" for spectral clustering, "louvain" for Louvain
community detection or "max" for clustering based on the maximum row value; note that
"max" is only appropriate for jrSiCKLSNMF with L2 norm row regularization}

\item{neighbors}{Number indicating the number of neighbors to use to generate the
graphs for spectral clustering and Louvain community detection: both of these
methods require the construction of a graph first (here we use KNN);
defaults to 20 and unused when the clustering method equal to "kmeans" or "max"}

\item{louvainres}{Numeric containing the resolution parameter for Louvain
community detection; unused for all other methods}
}
\value{
SickleJr- an object of class SickleJr with added clustering information
}
\description{
Perform k-means, spectral clustering, clustering based off of the
index of the maximum latent factor, or Louvain community detection on the \eqn{\mathbf{H}} matrix.
Defaults to k-means.
}
\examples{
SimSickleJrSmall<-ClusterSickleJr(SimSickleJrSmall,3)
SimSickleJrSmall<-ClusterSickleJr(SimSickleJrSmall,method="louvain",neighbors=5)
SimSickleJrSmall<-ClusterSickleJr(SimSickleJrSmall,method="spectral",neighbors=5,numclusts=3)
#DO NOT DO THIS FOR REAL DATA; this is just to illustrate max clustering
SimSickleJrSmall<-SetLambdasandRowReg(SimSickleJrSmall,rowReg="L2Norm")
SimSickleJrSmall<-ClusterSickleJr(SimSickleJrSmall,method="max")
}
\references{
\insertRef{louvain}{jrSiCKLSNMF}

\insertRef{Lun2016}{jrSiCKLSNMF}

\insertRef{Ng2001}{jrSiCKLSNMF}

\insertRef{Schliep2016}{jrSiCKLSNMF}

\insertRef{maxcluster}{jrSiCKLSNMF}
}
