% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge-data.table.R
\name{check_dt_by}
\alias{check_dt_by}
\title{Check dt \code{by} vars}
\usage{
check_dt_by(x, y, by, by.x, by.y)
}
\arguments{
\item{x}{left table}

\item{y}{right table}

\item{by}{character: variable to join by (common variable to x and y)}

\item{by.x}{character: specified var in x to join by}

\item{by.y}{character: specified var in y to join by}
}
\value{
character specifying checked variable(s) to join by
}
\description{
check variable(s) by which data frames are joined: either a single \code{by} var, common to right and left dt,
or
}
\examples{
\dontrun{
x = data.table(id1 = c(1, 1, 2, 3, 3),
               id2 = c(1, 1, 2, 3, 4),
               t   = c(1L, 2L, 1L, 2L, NA_integer_),
               x   = c(16, 12, NA, NA, 15))
y = data.table(id  = c(1, 2, 5, 6, 3),
               id2 = c(1, 1, 2, 3, 4),
               y   = c(11L, 15L, 20L, 13L, 10L),
               x   = c(16:20))
# example specifying by.x and by.y
joyn:::check_dt_by(x, y, by.x = "id1", by.y = "id2")
}
}
\keyword{internal}
