% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_vectors.R
\name{fmt_magnitude}
\alias{fmt_magnitude}
\title{Format magnitude}
\usage{
fmt_magnitude(
  x,
  digits = 1,
  nsmall = 1,
  decimal.mark = ".",
  mag = NULL,
  label_thousands = FALSE
)
}
\arguments{
\item{x}{[num] numeric vector}

\item{digits}{[int: default 1L] passed to `round()`}

\item{nsmall}{[int: default 1L] passed to `format()`}

\item{decimal.mark}{[chr: default "."] decimal mark passed to `format()`}

\item{mag}{[chr c("b", "m", "t")] magnitude (billion, million,
thousand) passed to set_magnitude()}

\item{label_thousands}{[lgl: default FALSE] allow thousands magnitude?  Not
Lancet-valid. Passed to `set_magnitude()`}
}
\value{
[chr] formatted string
}
\description{
Format a numeric vector into a string with specified magnitude (billion,
million, thousand).
}
\details{
Unaware of schema, just a hard-coded git-er-done function.

Caution - thousands magnitude is not Lancet compliant.
}
\examples{
fmt_magnitude(123456789)
}
\seealso{
Other vector_formats: 
\code{\link{format_oxford_comma}()},
\code{\link{fround}()},
\code{\link{fround_count}()},
\code{\link{fround_dtype}()},
\code{\link{fround_dtype_lancet}()},
\code{\link{fround_props}()}

Other magnitudes: 
\code{\link{set_magnitude}()}
}
\concept{magnitudes}
\concept{vector_formats}
