% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bfi_sample}
\alias{bfi_sample}
\title{Twenty-five personality self-report items taken from the International Personality Item Pool}
\format{
A data frame with 254 rows (250 original respondents, 4 generated for testing) and 33 variables:
\describe{
\item{\code{ID}}{Respondent ID}
\item{\code{A1}}{Am indifferent to the feelings of others. (reversed)}
\item{\code{A2}}{Inquire about others' well-being.}
\item{\code{A3}}{Know how to comfort others.}
\item{\code{A4}}{Love children.}
\item{\code{A5}}{Make people feel at ease.}
\item{\code{C1}}{Am exacting in my work.}
\item{\code{C2}}{Continue until everything is perfect.}
\item{\code{C3}}{Do things according to a plan.}
\item{\code{C4}}{Do things in a half-way manner. (reversed)}
\item{\code{C5}}{Waste my time. (reversed)}
\item{\code{E1}}{Don't talk a lot. (reversed)}
\item{\code{E2}}{Find it difficult to approach others. (reversed)}
\item{\code{E3}}{Know how to captivate people.}
\item{\code{E4}}{Make friends easily.}
\item{\code{E5}}{Take charge.}
\item{\code{N1}}{Get angry easily.}
\item{\code{N2}}{Get irritated easily.}
\item{\code{N3}}{Have frequent mood swings.}
\item{\code{N4}}{Often feel blue.}
\item{\code{N5}}{Panic easily.}
\item{\code{O1}}{Am full of ideas.}
\item{\code{O2}}{Avoid difficult reading material. (reversed)}
\item{\code{O3}}{Carry the conversation to a higher level.}
\item{\code{O4}}{Spend time reflecting on things.}
\item{\code{O5}}{Will not probe deeply into a subject. (reversed)}
\item{\code{gender}}{Gender of the respondent (female, male)}
\item{\code{age}}{Age of the respondent (years)}
\item{\code{AD}}{Exponent of age (computed: EXP(age))}
\item{\code{AF}}{Random data (for testing)}
\item{\code{AG}}{Random data (for testing)}
\item{\code{age_tr}}{Age of the respondent (transformed, as decades: 1 - 10-19, 2 - 20-29, 3 - 30-39, 4 - 40-49, 5 - 50-59, 6 - 60 and over)}
\item{\code{ID2}}{Respondent ID (for testing; "A" + random-generated 5-digit-code)}
}
}
\usage{
bfi_sample
}
\description{
The data set contains responses from 250 participants filling in twenty-five personality self-report items
taken from the International Personality Item Pool (https://ipip.ori.org) as part of the Synthetic Aperture
Personality Assessment (SAPA) web-based personality assessment (https://sapa-project.org) project.
The 25 items are organized by five putative factors: Agreeableness (A1 to A5), Conscientiousness (C1 to C5),
Extraversion (E1 to E5), Neuroticism (N1 to N5), and Openness (N1 to N5). The items were short phrases that
the respondent should answer by indicating how accurately the statement describes their typical behaviour or
attitude. Responses were collected using a 6-point scale: 1 - Very inaccurate, 2 - Moderately inaccurate,
3 - Slightly inaccurate, 4 - Slightly accurate, 5 - Moderately accurate, 6 - Very accurate.
}
\keyword{datasets}
