test_that("sort_omv works", {
    nmeInp <- paste0(tempfile(), ".rds")
    nmeOut <- paste0(tempfile(), "_S.omv")
    saveRDS(jmvReadWrite::AlbumSales, nmeInp)

    sort_omv(dtaInp = nmeInp, nmeOut, varSrt = "Image")
    expect_true(file.exists(nmeOut))
    expect_gt(file.info(nmeOut)$size, 1)
    expect_true(chkFle(nmeOut, isZIP = TRUE))
    expect_true(chkFle(nmeOut, fleCnt = "meta"))
    expect_true(chkFle(nmeOut, fleCnt = "metadata.json"))
    expect_true(chkFle(nmeOut, fleCnt = "data.bin"))
    df4Chk <- read_omv(nmeOut, sveAtt = FALSE)
    expect_s3_class(df4Chk, "data.frame")
    expect_equal(dim(df4Chk), c(200, 5))
    expect_equal(as.vector(sapply(df4Chk, typeof)), c("integer", "double", "integer", "integer", "integer"))
    expect_equal(as.integer(table(df4Chk[["Image"]])), c(3, 1, 1, 4, 17, 44, 73, 44, 12, 1))
    expect_equal(which(diff(as.integer(df4Chk[["Image"]])) == 1), c(3, 4, 5, 9, 26, 70, 143, 187, 199))
    expect_false(is.unsorted(df4Chk[["Image"]]))
    unlink(nmeInp)
    unlink(nmeOut)

    sort_omv(dtaInp = jmvReadWrite::AlbumSales, nmeOut, varSrt = "Image")
    expect_true(file.exists(nmeOut))
    expect_gt(file.info(nmeOut)$size, 1)
    expect_true(chkFle(nmeOut, isZIP = TRUE))
    expect_true(chkFle(nmeOut, fleCnt = "meta"))
    expect_true(chkFle(nmeOut, fleCnt = "metadata.json"))
    expect_true(chkFle(nmeOut, fleCnt = "data.bin"))
    df4Chk <- read_omv(nmeOut, sveAtt = FALSE)
    expect_s3_class(df4Chk, "data.frame")
    expect_equal(dim(df4Chk), c(200, 5))
    expect_equal(as.vector(sapply(df4Chk, typeof)), c("integer", "double", "integer", "integer", "integer"))
    expect_false(is.unsorted(df4Chk[["Image"]]))
    unlink(nmeOut)

    # test cases for code coverage and for the transfer of analyses ===========================================================================================
    expect_error(sort_omv(nmeInp, nmeOut, varSrt = c()))
    sort_omv(dtaInp = file.path("..", "ToothGrowth.omv"), fleOut = nmeOut, varSrt = "len", psvAnl = TRUE)
    expect_true(chkFle(nmeOut))
    expect_gt(file.info(nmeOut)$size, 1)
    expect_true(chkFle(nmeOut, isZIP = TRUE))
    expect_true(chkFle(nmeOut, fleCnt = "meta"))
    expect_true(chkFle(nmeOut, fleCnt = "metadata.json"))
    expect_true(chkFle(nmeOut, fleCnt = "data.bin"))
    df4Chk <- read_omv(nmeOut, sveAtt = FALSE, getSyn = TRUE)
    expect_s3_class(df4Chk, "data.frame")
    expect_equal(dim(df4Chk), c(60, 13))
    expect_equal(names(df4Chk), c("Filter 1", "ID", "logLen", "supp - Transform 1", "len", "supp", "dose", "dose2", "Trial", "Residuals", "J", "K", "L"))
    expect_equal(as.vector(sapply(df4Chk, typeof)),
      c("logical", "character", "double", "integer", "double", "integer", "double", "integer", "integer", "double", "double", "double", "integer"))
    expect_equal(zip::zip_list(nmeOut)$filename,
      c("data.bin", "strings.bin", "meta", "metadata.json", "xdata.json", "index.html", "01 empty/analysis", "02 anova/analysis", "03 empty/analysis",
        "04 ancova/analysis", "05 empty/analysis", "02 anova/resources/3b518ea3d44f095f.png", "02 anova/resources/07288f96c58ae68b.png"))
    expect_equal(attr(df4Chk, "syntax"),
      list(paste("jmv::ANOVA(formula = len ~ supp + dose2 + supp:dose2, data = data, effectSize = \"partEta\", modelTest = TRUE, qq = TRUE,",
                 "contrasts = list(list(var=\"supp\", type=\"none\"), list(var=\"dose2\", type=\"polynomial\")), postHoc = ~ supp + dose2, emMeans = ~ dose2:supp)"),
           "jmv::ancova(formula = len ~ supp + dose, data = data, effectSize = \"partEta\", modelTest = TRUE)"))
    expect_warning(sort_omv(dtaInp = jmvReadWrite::AlbumSales, fleOut = nmeOut, varSrt = "Sales", psvAnl = TRUE))
    unlink(nmeOut)
})
