% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conttablespaired.h.R
\name{contTablesPaired}
\alias{contTablesPaired}
\title{Paired Samples Contingency Tables}
\usage{
contTablesPaired(data, rows, cols, counts = NULL, pcRow = FALSE,
  pcCol = FALSE)
}
\arguments{
\item{data}{the data as a data frame}

\item{rows}{a string naming the variable to use as the rows in the 
contingency table}

\item{cols}{a string naming the variable to use as the columns in the 
contingency table}

\item{counts}{a string naming the variable to use as counts, or NULL if 
each row represents a single observation}

\item{pcRow}{\code{TRUE} or \code{FALSE} (default), provide row percentages}

\item{pcCol}{\code{TRUE} or \code{FALSE} (default), provide column 
percentages}
}
\description{
McNemar test
}
\examples{
dat <- data.frame(
    `1st survey` = c('Approve', 'Approve', 'Disapprove', 'Disapprove'),
    `2nd survey` = c('Approve', 'Disapprove', 'Approve', 'Disapprove'),
    `Counts` = c(794, 150, 86, 570),
    check.names=FALSE)

contTablesPaired(dat, rows = '1st survey', cols = '2nd survey', counts = 'Counts')

#
#  Paired Samples Contingency Tables
#
#  Contingency Tables
#  ------------------------------------------------
#    1st survey    Approve    Disapprove    Total
#  ------------------------------------------------
#    Approve           794           150      944
#    Disapprove         86           570      656
#    Total             880           720     1600
#  ------------------------------------------------
#
#
#  McNemar Test
#  -----------------------------------------------------
#                                Value    df    p
#  -----------------------------------------------------
#    X²                           17.4     1    < .001
#    X² continuity correction     16.8     1    < .001
#  -----------------------------------------------------
#

}
