
# This file is automatically generated, you probably don't want to edit this

#' @importFrom jmvcore Options
#' @importFrom R6 R6Class
ttestOneSOptions <- R6::R6Class(
    "ttestOneSOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            vars = NULL,
            students = TRUE,
            bf = FALSE,
            bfPrior = 0.707,
            mann = FALSE,
            testValue = 0,
            hypothesis = "dt",
            norm = FALSE,
            meanDiff = FALSE,
            effectSize = FALSE,
            ci = FALSE,
            ciWidth = 95,
            desc = FALSE,
            plots = FALSE,
            miss = "perAnalysis", ...) {

            super$initialize(
                package='jmv',
                name='ttestOneS',
                requiresData=TRUE,
                ...)
        
            private$..vars <- jmvcore::OptionVariables$new(
                "vars",
                vars,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "continuous",
                    "nominal",
                    "ordinal"),
                rejectInf=FALSE)
            private$..students <- jmvcore::OptionBool$new(
                "students",
                students,
                default=TRUE)
            private$..bf <- jmvcore::OptionBool$new(
                "bf",
                bf,
                default=FALSE)
            private$..bfPrior <- jmvcore::OptionNumber$new(
                "bfPrior",
                bfPrior,
                default=0.707,
                min=0.5,
                max=2)
            private$..mann <- jmvcore::OptionBool$new(
                "mann",
                mann,
                default=FALSE)
            private$..testValue <- jmvcore::OptionNumber$new(
                "testValue",
                testValue,
                default=0)
            private$..hypothesis <- jmvcore::OptionList$new(
                "hypothesis",
                hypothesis,
                options=list(
                    "dt",
                    "gt",
                    "lt"),
                default="dt")
            private$..norm <- jmvcore::OptionBool$new(
                "norm",
                norm,
                default=FALSE)
            private$..meanDiff <- jmvcore::OptionBool$new(
                "meanDiff",
                meanDiff,
                default=FALSE)
            private$..effectSize <- jmvcore::OptionBool$new(
                "effectSize",
                effectSize,
                default=FALSE)
            private$..ci <- jmvcore::OptionBool$new(
                "ci",
                ci,
                default=FALSE)
            private$..ciWidth <- jmvcore::OptionNumber$new(
                "ciWidth",
                ciWidth,
                min=50,
                max=99.9,
                default=95)
            private$..desc <- jmvcore::OptionBool$new(
                "desc",
                desc,
                default=FALSE)
            private$..plots <- jmvcore::OptionBool$new(
                "plots",
                plots,
                default=FALSE)
            private$..miss <- jmvcore::OptionList$new(
                "miss",
                miss,
                options=list(
                    "perAnalysis",
                    "listwise"),
                default="perAnalysis")
        
            self$.addOption(private$..vars)
            self$.addOption(private$..students)
            self$.addOption(private$..bf)
            self$.addOption(private$..bfPrior)
            self$.addOption(private$..mann)
            self$.addOption(private$..testValue)
            self$.addOption(private$..hypothesis)
            self$.addOption(private$..norm)
            self$.addOption(private$..meanDiff)
            self$.addOption(private$..effectSize)
            self$.addOption(private$..ci)
            self$.addOption(private$..ciWidth)
            self$.addOption(private$..desc)
            self$.addOption(private$..plots)
            self$.addOption(private$..miss)
        }),
    active = list(
        vars = function() private$..vars$value,
        students = function() private$..students$value,
        bf = function() private$..bf$value,
        bfPrior = function() private$..bfPrior$value,
        mann = function() private$..mann$value,
        testValue = function() private$..testValue$value,
        hypothesis = function() private$..hypothesis$value,
        norm = function() private$..norm$value,
        meanDiff = function() private$..meanDiff$value,
        effectSize = function() private$..effectSize$value,
        ci = function() private$..ci$value,
        ciWidth = function() private$..ciWidth$value,
        desc = function() private$..desc$value,
        plots = function() private$..plots$value,
        miss = function() private$..miss$value),
    private = list(
        ..vars = NA,
        ..students = NA,
        ..bf = NA,
        ..bfPrior = NA,
        ..mann = NA,
        ..testValue = NA,
        ..hypothesis = NA,
        ..norm = NA,
        ..meanDiff = NA,
        ..effectSize = NA,
        ..ci = NA,
        ..ciWidth = NA,
        ..desc = NA,
        ..plots = NA,
        ..miss = NA)
)

#' @import jmvcore
#' @importFrom R6 R6Class
ttestOneSResults <- R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        ttest = function() private$..ttest,
        normality = function() private$..normality,
        descriptives = function() private$..descriptives,
        plots = function() private$..plots),
    private = list(
        ..ttest = NA,
        ..normality = NA,
        ..descriptives = NA,
        ..plots = NA),
    public=list(
        initialize=function(options) {
            super$initialize(options=options, name="", title="One Sample T-Test")
            private$..ttest <- jmvcore::Table$new(
                options=options,
                name="ttest",
                title="One Sample T-Test",
                rows="(vars)",
                clearWith=list(
                    "hypothesis",
                    "testValue",
                    "miss"),
                columns=list(
                    list(`name`="var[stud]", `title`="", `content`="($key)", `type`="text", `combineBelow`=TRUE, `visible`="(students)"),
                    list(`name`="name[stud]", `title`="", `content`="Student's t", `visible`="(students)"),
                    list(`name`="stat[stud]", `title`="statistic", `type`="number", `visible`="(students)"),
                    list(`name`="err[stud]", `title`="error %", `type`="number", `visible`="(students && bf)", `content`=""),
                    list(`name`="df[stud]", `title`="df", `type`="number", `visible`="(students)"),
                    list(`name`="p[stud]", `title`="p", `type`="number", `format`="zto,pvalue", `visible`="(students)"),
                    list(`name`="md[stud]", `title`="Mean difference", `type`="number", `visible`="(meanDiff && students)"),
                    list(`name`="es[stud]", `title`="Cohen's d", `type`="number", `visible`="(effectSize && students)"),
                    list(`name`="cil[stud]", `title`="Lower", `type`="number", `visible`="(ci && students)"),
                    list(`name`="ciu[stud]", `title`="Upper", `type`="number", `visible`="(ci && students)"),
                    list(`name`="var[bf]", `title`="", `content`="($key)", `type`="text", `combineBelow`=TRUE, `visible`="(bf)"),
                    list(`name`="name[bf]", `title`="", `type`="text", `content`="Bayes factor\u2081\u2080", `visible`="(bf)"),
                    list(`name`="stat[bf]", `title`="statistic", `type`="number", `visible`="(bf)"),
                    list(`name`="err[bf]", `title`="\u00B1%", `type`="number", `visible`="(bf)"),
                    list(`name`="df[bf]", `title`="df", `type`="number", `visible`="(bf)", `content`=""),
                    list(`name`="p[bf]", `title`="p", `type`="number", `format`="zto,pvalue", `visible`="(bf)", `content`=""),
                    list(`name`="md[bf]", `title`="Mean difference", `type`="number", `visible`="(meanDiff && bf)", `content`=""),
                    list(`name`="sed[bf]", `title`="SE difference", `type`="number", `visible`="(meanDiff && bf)", `content`=""),
                    list(`name`="es[bf]", `title`="Cohen's d", `type`="number", `visible`="(effectSize && bf)", `content`=""),
                    list(`name`="cil[bf]", `title`="Lower", `type`="number", `visible`="(ci && bf)", `content`=""),
                    list(`name`="ciu[bf]", `title`="Upper", `type`="number", `visible`="(ci && bf)", `content`=""),
                    list(`name`="var[mann]", `title`="", `content`="($key)", `type`="text", `combineBelow`=TRUE, `visible`="(mann)"),
                    list(`name`="name[mann]", `title`="", `content`="Mann-Whitney U", `visible`="(mann)"),
                    list(`name`="stat[mann]", `title`="stat", `type`="number", `visible`="(mann)"),
                    list(`name`="err[mann]", `title`="\u00B1%", `type`="number", `visible`="(mann && bf)", `content`=""),
                    list(`name`="p[mann]", `title`="p", `type`="number", `format`="zto,pvalue", `visible`="(mann)"),
                    list(`name`="md[mann]", `title`="Mean difference", `type`="number", `visible`="(meanDiff && mann)"),
                    list(`name`="es[mann]", `title`="Cohen's d", `type`="number", `visible`="(effectSize && mann)"),
                    list(`name`="cil[mann]", `title`="Lower", `type`="number", `visible`="(ci && mann)"),
                    list(`name`="ciu[mann]", `title`="Upper", `type`="number", `visible`="(ci && mann)")))
            private$..normality <- jmvcore::Table$new(
                options=options,
                name="normality",
                title="Test of Normality (Shapiro-Wilk)",
                visible="(norm)",
                rows="(vars)",
                notes=list(`p`="A low p-value suggests a violation of the assumption of normality"),
                clearWith=list(
                    "miss"),
                columns=list(
                    list(`name`="name", `title`="", `content`="($key)", `type`="text"),
                    list(`name`="w", `title`="W", `type`="number"),
                    list(`name`="p", `type`="number", `format`="zto,pvalue")))
            private$..descriptives <- jmvcore::Table$new(
                options=options,
                name="descriptives",
                title="Descriptives",
                visible="(desc)",
                rows="(vars)",
                clearWith=list(
                    "miss"),
                columns=list(
                    list(`name`="name", `title`="", `content`="($key)", `type`="text"),
                    list(`name`="num", `title`="N", `type`="number"),
                    list(`name`="mean", `title`="Mean", `type`="number"),
                    list(`name`="median", `title`="Median", `type`="number"),
                    list(`name`="sd", `title`="SD", `type`="number"),
                    list(`name`="se", `title`="SE", `type`="number")))
            private$..plots <- jmvcore::Image$new(
                options=options,
                name="plots",
                title="Plots",
                visible="(plots)",
                renderFun=".plot",
                clearWith=list(
                    "vars",
                    "miss"))
            self$add(private$..ttest)
            self$add(private$..normality)
            self$add(private$..descriptives)
            self$add(private$..plots)}))

#' @importFrom jmvcore Analysis
#' @importFrom R6 R6Class
ttestOneSBase <- R6::R6Class(
    "ttestOneSBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'ttestOneS',
                version = c(1,0,0),
                options = options,
                results = ttestOneSResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = TRUE)
        }))

#' One Sample T-Test
#'
#' 
#'
#' @examples
#' data('ToothGrowth')
#' 
#' ttestOneS(ToothGrowth, vars = c('len', 'dose'))
#' 
#' #
#' # One Sample T-Test
#' #
#' # One Sample T-Test
#' # ------------------------------------------------------
#' #                          statistic    df      p
#' # ------------------------------------------------------
#' #   len     Student's t         19.1    59.0    < .001
#' #   dose    Student's t         14.4    59.0    < .001
#' # ------------------------------------------------------
#' #
#' 
#' @param data the data as a data frame
#' @param vars a vector of strings naming the variables of interest in 
#'   \code{data}
#' @param students \code{TRUE} (default) or \code{FALSE}, perform Student's 
#'   t-tests 
#' @param bf \code{TRUE} or \code{FALSE} (default), provide Bayes factors 
#' @param bfPrior a number between 0.5 and 2 (default 0.707), the prior width 
#'   to use in calculating Bayes factors 
#' @param mann \code{TRUE} or \code{FALSE} (default), perform Mann-Whitney U 
#'   test 
#' @param testValue a number specifying the value of the null hypothesis
#' @param hypothesis \code{'dt'} (default), \code{'gt'} or \code{'lt'}, the 
#'   alternative hypothesis; different to \code{testValue}, greater than 
#'   \code{testValue}, and less than \code{testValue} respectively 
#' @param norm \code{TRUE} or \code{FALSE} (default), perform Shapiro-wilk 
#'   tests of normality 
#' @param meanDiff \code{TRUE} or \code{FALSE} (default), provide means and 
#'   standard deviations 
#' @param effectSize \code{TRUE} or \code{FALSE} (default), provide effect 
#'   sizes 
#' @param ci \code{TRUE} or \code{FALSE} (default), provide confidence 
#'   intervals 
#' @param ciWidth a number between 50 and 99.9 (default: 95), the width of 
#'   confidence intervals 
#' @param desc \code{TRUE} or \code{FALSE} (default), provide descriptive 
#'   statistics 
#' @param plots \code{TRUE} or \code{FALSE} (default), provide descriptive 
#'   plots 
#' @param miss \code{'perAnalysis'} or \code{'listwise'}, how to handle 
#'   missing values; \code{'perAnalysis'} excludes missing values for individual 
#'   dependent variables, \code{'listwise'} excludes a row from all analyses if 
#'   one of its entries is missing. 
#' @export
ttestOneS <- function(
    data,
    vars,
    students = TRUE,
    bf = FALSE,
    bfPrior = 0.707,
    mann = FALSE,
    testValue = 0,
    hypothesis = "dt",
    norm = FALSE,
    meanDiff = FALSE,
    effectSize = FALSE,
    ci = FALSE,
    ciWidth = 95,
    desc = FALSE,
    plots = FALSE,
    miss = "perAnalysis") {

    options <- ttestOneSOptions$new(
        vars = vars,
        students = students,
        bf = bf,
        bfPrior = bfPrior,
        mann = mann,
        testValue = testValue,
        hypothesis = hypothesis,
        norm = norm,
        meanDiff = meanDiff,
        effectSize = effectSize,
        ci = ci,
        ciWidth = ciWidth,
        desc = desc,
        plots = plots,
        miss = miss)

    results <- ttestOneSResults$new(
        options = options)

    analysis <- ttestOneSClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
