% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jmdl.R
\name{jmdl}
\alias{jmdl}
\title{Fit Joint Mean-Correlation Models For Discrete Longitudinal Data}
\usage{
jmdl(formula, data = NULL, q = 2, theta = NULL, W.appendix = NULL,
  offset = NULL, family = c("Bernoulli", "Nbinom", "Poisson"))
}
\arguments{
\item{formula}{a two-sided linear formula object describing the correlation
for both the mean and correlation matrix part of the model, with the response,
the corresponding subject id and measurement time on the left of a operator~,
divided by vertical bars ("|").}

\item{data}{data frame containing the variables named in formula.}

\item{q}{degree of polynomial of the time lag to model the lower triangular matrix.}

\item{theta}{starting values for the parameters in the model.}

\item{W.appendix}{appendix array to model time-dependent covariates for the lower triangular matrix.}

\item{offset}{a term to be added to the linear predictor.}

\item{family}{the marginal distributions of the discrete variables.
choose 'Bernoulli', 'Poisson' or 'Nbinom'.}
}
\description{
Fit a joint mean-correlation model to discrete longitudinal data.
}
\examples{
data(toydata)
mydat <- toydata
fit <- jmdl(Y|id|time ~ X, data = mydat, q = 2, family ='Bernoulli')
}
