% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{survfitJMCS}
\alias{survfitJMCS}
\title{Prediction using \code{FastJM}}
\usage{
survfitJMCS(model, ids, u, method = "GH", obs.time)
}
\arguments{
\item{model}{fitted model object}

\item{ids}{value of id}

\item{u}{see \code{survfitjmcs}}

\item{method}{options are 'Laplace','GH'}

\item{obs.time}{vector which represents time variable in the longitudinal data}
}
\value{
list of predicted value for the given id along with other information relevant for survival probability confidence plot
}
\description{
prediction of survival probability using \code{FastJM} for BIG data
}
\examples{
  \donttest{
##
library(survival)
library(dplyr)
jmcs1<-jmcsBig(dtlong=data.frame(long2),
dtsurv = data.frame(surv2),
longm=y~ x7+visit,
survm=Surv(time,status)~x1+visit,
rd= ~ visit|id,
samplesize=200,id='id')
mod2<-jmcs1
P2<-survfitJMCS(model<-mod2,ids<-c(5),u<-seq(surv2[surv2$id==5,]$time,
surv2[surv2$id==5,]$time+10,0.2),obs.time='time')
print(P2)
##
  }
}
