% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment.R
\name{segment}
\alias{segment}
\title{Chinese text segmentation function}
\usage{
segment(code, jiebar, mod = NULL)
}
\arguments{
\item{code}{A Chinese sentence or the path of a text file.}

\item{jiebar}{jiebaR Worker.}

\item{mod}{change default result type, value can be "mix","hmm","query","full","level", or "mp"}
}
\description{
The function uses initialized engines for words segmentation. You 
can initialize multiple engines simultaneously using \code{worker()}.
Public settings of workers can be got and modified using \code{$}, 
such as \code{ WorkerName$symbol = T }. Some private settings are fixed 
when engine is initialized, and you can get then by 
\code{WorkerName$PrivateVarible}.
}
\details{
There are four kinds of models:

Maximum probability segmentation model uses Trie tree to construct
a directed acyclic graph and uses dynamic programming algorithm. It
is the core segmentation algorithm. \code{dict} and \code{user}
should be provided when initializing jiebaR worker.
 
Hidden Markov Model uses HMM model to determine status set and 
observed set of words. The default HMM model is based on People's Daily 
language library. \code{hmm} should be provided when initializing 
jiebaR worker.

MixSegment model uses both Maximum probability segmentation model 
and Hidden Markov Model to construct segmentation.  \code{dict}, 
\code{hmm} and \code{user} should be provided when initializing 
jiebaR worker.

QuerySegment model uses MixSegment to construct segmentation and then 
enumerates all the possible long words in the dictionary.  \code{dict}, 
\code{hmm} and \code{qmax} should be provided when initializing 
jiebaR worker.

There is a symbol \code{<=} for this function.
}
\seealso{
\code{\link{<=.segment}} \code{\link{worker}}
}

