% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{package}
\name{jiebaR}
\alias{jiebaR}
\alias{jiebaR-package}
\title{A package for Chinese text segmentation}
\description{
This is a package for Chinese text segmentation, keyword extraction
and speech tagging with Rcpp and cppjieba. JiebaR supports four
types of segmentation mode: Maximum Probability, Hidden Markov Model,
Query Segment and Mix Segment.
}
\details{
You can use custom
dictionary to be included in the jiebaR default dictionary. JiebaR can
also identify new words, but adding your own new words will ensure a higher
accuracy.
}
\examples{
### Note: Can not display Chinese character here.
\donttest{
words = "hello world"
test1 = worker()
test1 <= words
}

\dontrun{
test <= "./temp.txt"
engine2 = worker("hmm")
engine2 <= "./temp.txt"
engine2$write = T
engine2 <= "./temp.txt"
engine3 = worker(type = "mix", dict = "dict_path",symbol = T)
engine3 <= "./temp.txt"
 }
\donttest{
### Keyword Extraction
keys = worker("keywords", topn = 1)
keys <= words

### Speech Tagging
tagger = worker("tag")
tagger <= words

### Simhash
simhasher = worker("simhash", topn = 1)
simhasher <= words
distance("hello world" , "hello world!" , simhasher)

show_dictpath()
}
}
\author{
Qin Wenfeng <\url{http://qinwenfeng.com}>
}
\references{
CppJieba \url{https://github.com/aszxqw/cppjieba};
}
\seealso{
JiebaR \url{https://github.com/qinwf/jiebaR};
}

