% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\docType{data}
\name{stemcells}
\alias{stemcells}
\title{Meta-analysis of 31 randomized controled trials (RCTs) with reported discrepancies}
\format{
A matrix with 31 rows and 11 columns. Each row represents study results, the columns are:
   \describe{
    \item{trial}{ID name of the trial.}
    \item{effect.size}{treatment effect is measured as the difference of the
          ejection fraction between groups, which measures the improvement of
          left ventricular function in the heart.}
    \item{se.effect}{Standard Error of the effect.size.}
    \item{sample.size}{Total number of patients in the trial.}
    \item{n.discrep}{Number of detected discrepancies in the published trial.
    Discrepancies are defined as two or more reported facts that cannot both be
    true because they are logically or mathematically incompatible.}
    \item{Sequence}{Bias arising from the randomization process.}
    \item{Allocation}{Bias due to deviations from intended interventions.}
    \item{Blinding}{Bias introduced by lack of blinding.}
    \item{Outcome}{Bias in measurement of the outcome.}
    \item{Reporting}{Bias in selection of the reported result.}
    \item{Other}{Selection bias, performance bias, detection bias, attrition bias, etc.}

    }
}
\source{
Nowbar, A N, et al. (2014) Discrepancies in autologous bone marrow stem cell trials and enhancemen of ejection fraction (DAMASCENE): weighted regression and meta-analysis. BMJ, 348,1-9.
}
\description{
Meta-analysis of 31 randomized controled trials (RCTs) of two treatment groups
of heart disease patients, where the treatment group received bone marrow stem
cells and the control group a placebo treatment.
}
\references{
Verde, P. E. (2017) Two Examples of Bayesian Evidence Synthesis with the Hierarchical Meta-Regression Approach. Chap.9, pag 189-206. Bayesian Inference, ed. Tejedor, Javier Prieto. InTech.
}
\keyword{datasets}
