% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gesmix.R
\name{gesmix}
\alias{gesmix}
\title{Generalized Evidence Synthesis with Indirect Penalization of Observational Studies}
\usage{
gesmix(data, mean.mu = 0, sd.mu = 10^6, scale.sigma = 0.5,
  K.lower = -10, K.upper = 0, nr.chains = 2, nr.iterations = 10000,
  nr.adapt = 1000, nr.burnin = 1000, nr.thin = 1, be.quiet = FALSE,
  r2jags = TRUE)
}
\arguments{
\item{data}{A data frame with at least three variables with the following names:
1) TE = treatment effect, 
2) seTE = the standard error of the treatment effect
3) design = the study type. The other columns of the data 
frame may correspond to the study name and other covariates that
characterize the study and could influence internal validity bias
(e.g. evaluation of risk of bias).}

\item{mean.mu}{Prior mean of the overall mean parameter mu, default value is 0.}

\item{sd.mu}{Prior standard deviation of mu, the default value is 10^-6.}

\item{scale.sigma}{Prior scale parameter for the standard deviation between studies, 
the default value is 0.5.}

\item{K.lower}{Lower bound of the bias parameter K, the default value is -10.}

\item{K.upper}{Upper bound of the bias parameter K, the default value is 0.}

\item{nr.chains}{Number of chains for the MCMC computations, default 2.}

\item{nr.iterations}{Number of iterations after adapting the MCMC, default is 10000. Some models may need more iterations.}

\item{nr.adapt}{Number of iterations in the adaptation process, defualt is 1000. Some models may need more iterations during adptation.}

\item{nr.burnin}{Number of iteration discared for burnin period, default is 1000. Some models may need a longer burnin period.}

\item{nr.thin}{Thinning rate, it must be a positive integer, the default value 1.}

\item{be.quiet}{Do not print warning message if the model does not adapt. The default value is FALSE. If you are not sure about the adaptation period choose be.quiet=TRUE.}

\item{r2jags}{Which interface is used to link R to JAGS (rjags and R2jags), default value is R2Jags=TRUE.}
}
\value{
This function returns an object of the class "gesmix". 
This object contains the MCMC output of
each parameter and hyper-parameter in the model and 
the data frame used for fitting the model.
}
\description{
This function performers a Bayesian meta-analysis to jointly
combine different types of studies. The random-effects follows a finite
mixture of normals.
}
\details{
The results of the object of the class gesmix can be extracted with R2jags
or with rjags. In addition a summary, a print and a plot functions are 
implemented for this type of object.
}
\examples{
\dontrun{

 library(jarbes)
 
out = gesmix(data = ppvipd)
attach.jags(out, overwrite = TRUE)

par(mfrow = c(1,2))
hist(lambda[,1],  breaks = 100, probability = TRUE,
    ylim = c(0, 3),
    xlim = c(-2, 0.85), main = "",
    xlab = "Treatment Effect: log(Odds Ratio)")

lines(density(lambda[,2]), lwd = 3, col = "red")
lines(density(lambda[,1]), lwd = 3, col = "blue")
abline(v = 0, lty = 2)
legend(-2, 3, legend = c("RCTs' Component",
                        "Obsevationals' Component"),
      col = c("blue", "red"),
      lty = rep(1, 2),
      lwd = rep(2, 2))
hist(c(lambda[,1],lambda[,2]+0.337), 
    breaks = 150,
    probability = TRUE,
    ylim = c(0, 3.5),
    xlim = c(-2.1, 0.2), main = "",
    xlab = "Treatment Effect: log(Odds Ratio)")
lines(density(c(lambda[,1],lambda[,2]+0.337)), col = "blue", lwd =3)
abline(v = quantile(c(lambda[,1],lambda[,2]+0.337), 
                   probs = c(0.025,0.5,0.975)), col ="blue",
      lty = 2)
m.pool <- log(0.43)
sd.pool <- (log(0.54) - log(0.34))/(2*1.96)
curve(dnorm(x, m = m.pool, s = sd.pool), 
     from = -3, to = 0.5, add = TRUE, col = "black", lwd =3)
legend(-2.1, 3, 
      legend = c("Bias-adjusted",
                 "Biased result"),
      col = c("blue", "black"),
      lty = rep(1, 2),
      lwd = rep(2, 2))
abline(v = 0, lty = 2)
arrows(-1.5, 1.1, -1, 1.55, lwd =2, length=0.1, angle=20)
text(-1.8, 1, "Ignoring study types")
par(mfrow = c(1,1))
}
}
\references{
Verde, P. E. (2017) Two Examples of Bayesian Evidence Synthesis with the Hierarchical Meta-Regression Approach. Chap.9, pag 189-206. Bayesian Inference, ed. Tejedor, Javier Prieto. InTech.

Verde, P.E. and Curcio, D. (2019) Hierarchical Meta-Regression Modelling: The Case of The Pneumococcal Polysaccharide Vaccine. Technical Report.
}
