% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_clean_names.R
\name{make_clean_names}
\alias{make_clean_names}
\title{Cleans a vector of text, typically containing the names of an object.}
\usage{
make_clean_names(
  string,
  case = c("snake", "lower_camel", "upper_camel", "screaming_snake", "lower_upper",
    "upper_lower", "all_caps", "small_camel", "big_camel", "old_janitor", "parsed",
    "mixed", "none")
)
}
\arguments{
\item{string}{A character vector of names to clean.}

\item{case}{The desired target case (default is \code{"snake"}), indicated by these possible values:
\itemize{
 \item{\code{"snake"} produces snake_case}
 \item{\code{"lower_camel"} or \code{"small_camel"} produces lowerCamel}
 \item{\code{"upper_camel"} or \code{"big_camel"} produces UpperCamel}
 \item{\code{"screaming_snake"} or \code{"all_caps"} produces ALL_CAPS}
 \item{\code{"lower_upper"} produces lowerUPPER}
 \item{\code{"upper_lower"} produces UPPERlower}
 \item{\code{old_janitor}: legacy compatibility option to preserve behavior of \code{clean_names} prior to addition of the "case" argument(janitor versions <= 0.3.1 )}.  Provided as a quick fix for old scripts broken by the changes to \code{clean_names} in janitor v1.0.
 \item{\code{"parsed"}, \code{"mixed"}, \code{"none"}: less-common cases offered by \code{snakecase::to_any_case}.  See \code{\link[snakecase]{to_any_case}} for details.}
 }}
}
\value{
Returns the "cleaned" character vector.
}
\description{
Resulting strings are unique and consist only of the \code{_} character, numbers, and letters.
Capitalization preferences can be specified using the \code{case} parameter.

For use on the names of a data.frame, e.g., in a \code{`\%>\%`} pipeline,
call the convenience function \code{\link[janitor]{clean_names}}.

Accented characters are transliterated to ASCII.  For example, an "o" 
with a German umlaut over it becomes "o", and the Spanish character "enye" becomes "n".
}
\examples{

# cleaning the names of a vector:
x <- structure(1:3, names = c("name with space", "TwoWords", "total $ (2009)"))
x
names(x) <- make_clean_names(names(x))
x # now has cleaned names
# if you prefer camelCase variable names:
make_clean_names(names(x), "small_camel")

# similar to janitor::clean_names(poorly_named_df):
# not run:
# make_clean_names(names(poorly_named_df))

}
