% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-colors.r
\name{hsv2col}
\alias{hsv2col}
\title{Convert HSV matrix to R color}
\usage{
hsv2col(hsvValue, ...)
}
\arguments{
\item{hsvValue}{\code{numeric} HSV matrix, with rownames c("h","s","v")
in any order, and optionally "alpha" rowname for alpha transparency.}

\item{...}{additional arguments are ignored.}
}
\value{
\code{character} vector of R colors.
}
\description{
Converts a HSV color matrix to R hex color
}
\details{
This function augments the \code{grDevices::hsv()} function in that it handles
output from \code{grDevices::rgb2hsv()} or \code{col2hsv()}, sufficient to
run a series of conversion functions, e.g. \code{hsv2col(col2hsv("red"))}.
This function also maintains alpha transparency, which is not maintained
by the \code{grDevices::hsv()} function.
}
\examples{
# start with a color vector
# red and blue with partial transparency
colorV <- c("#FF000055", "#00339999");

# confirm the hsv matrix maintains transparency
col2hsv(colorV);

# convert back to the original color
hsv2col(col2hsv(colorV));

}
\seealso{
Other jam color functions: 
\code{\link{alpha2col}()},
\code{\link{applyCLrange}()},
\code{\link{col2alpha}()},
\code{\link{col2hcl}()},
\code{\link{col2hsl}()},
\code{\link{col2hsv}()},
\code{\link{color2gradient}()},
\code{\link{fixYellow}()},
\code{\link{fixYellowHue}()},
\code{\link{getColorRamp}()},
\code{\link{hcl2col}()},
\code{\link{hsl2col}()},
\code{\link{isColor}()},
\code{\link{kable_coloring}()},
\code{\link{makeColorDarker}()},
\code{\link{rainbow2}()},
\code{\link{rgb2col}()},
\code{\link{setCLranges}()},
\code{\link{setTextContrastColor}()},
\code{\link{showColors}()},
\code{\link{unalpha}()},
\code{\link{warpRamp}()}
}
\concept{jam color functions}
