% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pip.R
\name{pip}
\alias{pip}
\title{Compute posterior inclusion probabilities (PIPs)}
\usage{
pip(pvalue, group = NULL, pi0 = NULL, verbose = TRUE, ...)
}
\arguments{
\item{pvalue}{a vector of p-values.}

\item{group}{a vector of group indicators (optional).
If provided, PIP analysis is stratified.
Assumes groups are in 1:k where k is the number of unique groups.}

\item{pi0}{a vector of pi0 values (optional).
Its length has to be either 1 or equal the number of groups.}

\item{verbose}{If TRUE, reports information.}

\item{...}{optional arguments for \code{\link[qvalue]{lfdr}} to control a local FDR estimation.}
}
\value{
\code{pip} returns a vector of posterior inclusion probabilities
}
\description{
From a set of p-values, computes posterior probabilities that a feature should be truly included.
For example, membership inclusion in a given cluster can be improved by filtering low quality members.
In using PCA and related methods, it helps select variables that are truly associated with given latent variables.
}
\references{
Chung (2020) Statistical significance of cluster membership for unsupervised evaluation of cell identities. Bioinformatics, 36(10): 3107–3114 \doi{10.1093/bioinformatics/btaa087}

Chung (2014) "Jackstraw Weighted Shrinkage for Principal Component Analysis and Covariance Matrix" in Statistical Inference of Variables Driving Systematic Variation in High-Dimensional Biological Data. PhD thesis, Princeton University. \url{https://www.proquest.com/openview/e90b562d689cf3a021c35a93c6f346db/1?pq-origsite=gscholar&cbl=18750}
}
\author{
Neo Christopher Chung \email{nchchung@gmail.com}
John R. Yamamoto-Wilson
}
