% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorialSchurPol.R
\name{factorialSchurPol}
\alias{factorialSchurPol}
\title{Factorial Schur polynomial}
\usage{
factorialSchurPol(n, lambda, a)
}
\arguments{
\item{n}{number of variables}

\item{lambda}{integer partition}

\item{a}{vector of \code{bigq} numbers, or vector of elements coercible
to \code{bigq} numbers; this vector corresponds to the sequence denoted by
\eqn{a} in the
\href{https://www.kurims.kyoto-u.ac.jp/EMIS/journals/SLC/opapers/s28macdonald.pdf}{reference paper},
section \strong{6th Variation} (in this paper \eqn{a} is a doubly
infinite sequence, but in the case of a non-skew partition, the
non-positive indices of this sequence are not involved); the length of
this vector must be large enough (an error will be thrown if it is too
small) but it is not easy to know the minimal possible length}
}
\value{
A \code{qspray} polynomial.
}
\description{
Computes a factorial Schur polynomial.
}
\examples{
# for a=c(0, 0, ...), the factorial Schur polynomial is the Schur polynomial
n <- 3
lambda <- c(2, 2, 2)
a <- c(0, 0, 0, 0)
factorialSchurPoly <- factorialSchurPol(n, lambda, a)
schurPoly <- SchurPol(n, lambda)
factorialSchurPoly == schurPoly # should be TRUE
}
\references{
I.G. Macdonald.
\emph{Schur functions: theme and variations}.
Publ. IRMA Strasbourg, 1992.
}
