% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lp.R
\name{obsEqMin}
\alias{obsEqMin}
\title{Minimizing violation of observational equivalence}
\usage{
obsEqMin(sset, orig.sset = NULL, orig.criterion = NULL,
  criterion.tol = 0, lpobj, lpsolver, debug = FALSE)
}
\arguments{
\item{sset}{A list of IV-like estimates and the corresponding gamma
terms.}

\item{orig.sset}{list, only used for bootstraps. The list
caontains the gamma moments for each element in the S-set, as
well as the IV-like coefficients.}

\item{orig.criterion}{numeric, only used for bootstraps. The scalar
corresponds to the minimum observational equivalence criterion
from the original sample.}

\item{criterion.tol}{tolerance for violation of observational
equivalence, set to 0 by default.}

\item{lpobj}{A list of matrices and vectors defining an LP problem.}

\item{lpsolver}{string, name of the package used to solve the LP
problem.}

\item{debug}{boolean, indicates whether or not the function should
provide output when obtaining bounds. The option is only
applied when \code{lpsolver = 'gurobi'}. The output provided is
the same as what the Gurobi API would send to the console.}
}
\value{
A list including the minimum violation of observational
    equivalence, the solution to the LP problem, and the status of
    the solution.
}
\description{
Given a set of IV-like estimates and the set of matrices/vectors
defining an LP problem, this function minimizes the violation of
observational equivalence under the L1 norm.
}
\examples{
dtm <- ivmte:::gendistMosquito()

## Declare empty list to be updated (in the event multiple IV like
## specifications are provided
sSet <- list()

## Declare MTR formulas
formula1 = ~ 1 + u
formula0 = ~ 1 + u

## Construct object that separates out non-spline components of MTR
## formulas from the spline components. The MTR functions are
## obtained from this object by the function 'genSSet'.
splinesList = list(removeSplines(formula0), removeSplines(formula1))

## Construct MTR polynomials
polynomials0 <- polyparse(formula = formula0,
                 data = dtm,
                 uname = u,
                 as.function = FALSE)
polynomials1 <- polyparse(formula = formula0,
                 data = dtm,
                 uname = u,
                 as.function = FALSE)

## Generate propensity score model
propensityObj <- propensity(formula = d ~ z,
                            data = dtm,
                            link = "linear")

## Generate IV estimates
ivEstimates <- ivEstimate(formula = ey ~ d | z,
                          data = dtm,
                          components = l(intercept, d),
                          treat = d,
                          list = FALSE)

## Generate target gamma moments
targetGamma <- genTarget(treat = "d",
                         m0 = ~ 1 + u,
                         m1 = ~ 1 + u,
                         target = "atu",
                         data = dtm,
                         splinesobj = splinesList,
                         pmodobj = propensityObj,
                         pm0 = polynomials0,
                         pm1 = polynomials1,
                         point = FALSE)

## Construct S-set. which contains the coefficients and weights
## corresponding to various IV-like estimands
sSet <- genSSet(data = dtm,
                sset = sSet,
                sest = ivEstimates,
                splinesobj = splinesList,
                pmodobj = propensityObj$phat,
                pm0 = polynomials0,
                pm1 = polynomials1,
                ncomponents = 2,
                scount = 1,
                yvar = "ey",
                dvar = "d",
                means = TRUE)

## Define additional upper- and lower-bound constraints for the LP
## problem
A <- matrix(0, nrow = 22, ncol = 4)
A <- cbind(A, rbind(cbind(1, seq(0, 1, 0.1)),
                    matrix(0, nrow = 11, ncol = 2)))
A <- cbind(A, rbind(matrix(0, nrow = 11, ncol = 2),
                    cbind(1, seq(0, 1, 0.1))))

sense <- c(rep(">", 11), rep("<", 11))
rhs <- c(rep(0.2, 11), rep(0.8, 11))

## Construct LP object to be interpreted and solved by lpSolveAPI
lpObject <- lpSetup(sset = sSet$sset,
                    mbA = A,
                    mbs = sense,
                    mbrhs = rhs,
                    lpsolver = "lpSolveAPI")

## Estimate the bounds
obsEqMin(sset = sSet$sset,
         lpobj = lpObject,
         lpsolver = "lpSolveAPI")

}
