% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{compareML}
\alias{compareML}
\title{Function for comparing two GAMM models.}
\usage{
compareML(
  model1,
  model2,
  signif.stars = TRUE,
  suggest.report = FALSE,
  print.output = TRUE
)
}
\arguments{
\item{model1}{First model.}

\item{model2}{Second model.}

\item{signif.stars}{Logical (default = TRUE). Whether or not to display 
stars indicating the level of significance on 95\% confidence level.}

\item{suggest.report}{Logical (default = FALSE). Whether or not to 
present a suggestion on how one could report the information. If 
\code{print.output} is set to FALSE, \code{suggest.report} will 
set to FALSE too. Please inspect yourself whether the label between 
square bracket fits your own standards. Note: the \code{X2} should be 
replaced by a proper Chi-Square symbol \eqn{\chi^2}{}.}

\item{print.output}{Logical: whether or not to print the output. 
By default set to true, even if the the messages are not allowed by 
a global package option using the function \code{\link{infoMessages}}.}
}
\value{
Optionally returns the Chi-Square test table.
}
\description{
Function for comparing two GAMM models.
}
\details{
As an Chi-Square test is performed on two times the difference in 
minimized smoothing parameter selection score (GCV, fREML, REML, ML), 
and the difference in degrees of freedom specified in the model. 
The degrees of freedom of the model terms are the sum of
1) the number of estimated smoothing parameters for the model, 
2) number of parametric (non-smooth) model terms including the intercept, 
and 3) the sum of the penalty null space dimensions of each smooth object.

This method is preferred over other functions such as \code{\link{AIC}} for 
models that include an AR1 model or random effects (especially nonlinear 
random smooths using \code{bs='fs'}). CompareML also reports the AIC 
difference, but that value should be treated with care.

Note that the Chi-Square test will result in a very low p-value
when the difference in degrees of freedom approaches zero. Use common sense 
to determine if the difference between the two models is meaningful. 
A warning is presented when the difference in score is smaller 
than 5.

The order of the two models is not important.
Model comparison is only implemented for the methods GCV, fREML, REML, and ML.
}
\section{Notes}{

For suppressing the output and all warnings, set infoMessages to FALSE 
(\code{infoMessages('off')} ), set the argument \code{print.output} to FALSE,
and use the function 
\code{\link{suppressWarnings}} to suppress warning messages.
}

\examples{
data(simdat)

\dontrun{
infoMessages('on')
# some arbitrary models:
m1 <- bam(Y~Group + s(Time, by=Group), method='fREML', data=simdat)
m2 <- bam(Y~Group + s(Time), method='fREML', data=simdat)

compareML(m1, m2)

# exclude significance stars:
compareML(m1, m2, signif.stars=FALSE)

m3 <- bam(Y~Group + s(Time, by=Group, k=25), method='fREML', 
    data=simdat)
compareML(m1, m3)

# do not print output, but save table for later use:
cml <- compareML(m1, m2, print.output=FALSE)$table
cml

# Use suppressWarnings to also suppress warnings:
suppressWarnings(cml <- compareML(m1, m2, print.output=FALSE)$table)

}
}
\seealso{
For models without AR1 model or random effects \code{\link{AIC}} can be used.

Other Testing for significance: 
\code{\link{plot_diff2}()},
\code{\link{plot_diff}()},
\code{\link{report_stats}()},
\code{\link{wald_gam}()}
}
\author{
Jacolien van Rij. With many thanks to Simon N. Wood for his feedback.
}
\concept{Testing for significance}
