% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{missing_est}
\alias{missing_est}
\title{Return indices of data that were not fitted by the model.}
\usage{
missing_est(model)
}
\arguments{
\item{model}{A fitted regression model (using lm, glm, gam, or bam).}
}
\value{
The indices of the data that were not fitted by the model.
}
\description{
Return indices of data that were not fitted by the model.
}
\examples{
data(simdat)

# Add missing values:
set.seed(123)
simdat[sample(nrow(simdat), size=20),]$Y <- NA
# Fit simple linear model:
lm1 <- lm(Y ~ Time, data=simdat)
na.el <- missing_est(lm1)
length(na.el)

}
\seealso{
Other Utility functions: \code{\link{convertNonAlphanumeric}},
  \code{\link{diff_terms}}, \code{\link{find_difference}},
  \code{\link{print_summary}}, \code{\link{summary_data}},
  \code{\link{timeBins}}
}
\author{
Jacolien van Rij
}
