% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{set_specie}
\alias{set_specie}
\title{Constructor of Instances of the Specie Class}
\usage{
set_specie(data, meiosis = NULL)
}
\arguments{
\item{data}{A data frame with the map of the Genome to be simulates.}

\item{meiosis}{A pointer to a C++ function of the meiosis process.}
}
\value{
Objects of R6 class with methods to mimic in silico Genomes.
}
\description{
Constructor of instances of the Specie class given the map of
    the genome and optionally a pointer to a C++ function which will drive
    the meiosis process.
}
\examples{
data(ToyMap)
spc_standard <- set_specie(ToyMap)

## generate standard _de novo_ variability
spc_standard$gamete(n = 10)

## Writing your own meiosis process and using it
\dontrun{
src <- '
// [[Rcpp::depends(isqg)]]

# include <isqg.h>

Map meiosis(double i, double j) { return Map(1, R::runif(0.0, 1.0) > .5 ? 1 : 0) ; }

// [[Rcpp::export]]
MPtr myMeiosis() { return MPtr(new FPtr(& meiosis), true) ; }
'

Rcpp::sourceCpp(code = src, rebuild = TRUE)
spc_custom <- set_specie(ToyMap, meiosis = myMeiosis())

## generate custom _de novo_ variability
scp_custom$gamete(n = 10)
}

}
