% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/coordinates.R
\docType{methods}
\name{coordinates_cartesian}
\alias{coordinates_cartesian}
\alias{coordinates_cartesian-method}
\alias{coordinates_cartesian,numeric,numeric-method}
\alias{coordinates_cartesian,ANY,missing-method}
\title{Cartesian Coordinates}
\usage{
coordinates_cartesian(x, y, z, ...)

\S4method{coordinates_cartesian}{numeric,numeric}(x, y)

\S4method{coordinates_cartesian}{ANY,missing}(x, xlab = NULL, ylab = NULL)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector giving the x and y ternary coordinates of a
set of points. If \code{y} is missing, an attempt is made to interpret \code{x} in a
suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Currently not used.}

\item{xlab, ylab}{A \code{\link{character}} string specifying the names for the x and y
variables to be extracted.}
}
\value{
A \code{\link{list}} with the components:
\tabular{ll}{
\code{x} \tab A \code{\link{numeric}} vector of x values. \cr
\code{y} \tab A \code{\link{numeric}} vector of y values. \cr
\code{z} \tab A \code{\link{numeric}} vector of z values. \cr
}
}
\description{
Computes cartesian coordinates.
}
\examples{
## Compositional data
coda <- data.frame(
  x = c(1, 0, 0, 1/3),
  y = c(0, 1, 0, 1/3),
  z = c(0, 0, 1, 1/3)
)

## Ternary coordinates
(tern <- coordinates_ternary(coda))

## Cartesian coordinates
(cart <- coordinates_cartesian(tern))
}
\seealso{
Other coordinates: 
\code{\link{coordinates_ternary}()}
}
\author{
N. Frerebeau
}
\concept{coordinates}
\keyword{internal}
