context("test-iso-to-sfg")

test_that("conversion of isolines to sfg", {
  #m <- matrix(c(0, 0, 0, 2,
  #              0, 1, 0, 2,
  #              0, 0, 0, 0), 3, 4, byrow = TRUE)
  #lines <- isolines(1:4, 3:1, m, c(0.5, 1.5))

  lines <- structure(
    list(
      `0.5` = list(
        x = c(2.00, 2.50, 2.00, 1.50, 2.00, 3.25, 3.25, 4.00),
        y = c(1.50, 2.00, 2.50, 2.00, 1.50, 3.00, 2.00, 1.25),
        id = c(1, 1, 1, 1, 1, 2, 2, 2)
      ),
      `1.5` = list(
        x = c(3.75, 3.75, 4.00),
        y = c(3.00, 2.00, 1.75),
        id = c(1, 1, 1)
      )
    ),
    class = c("isolines", "iso")
  )

  out <- iso_to_sfg(lines)

  expect_equal(
    out[["0.5"]][[1]],
    cbind(
      c(2.00, 2.50, 2.00, 1.50, 2.00),
      c(1.50, 2.00, 2.50, 2.00, 1.50)
    )
  )

  expect_equal(
    out[["0.5"]][[2]],
    cbind(
      c(3.25, 3.25, 4.00),
      c(3.00, 2.00, 1.25)
    )
  )

  expect_equal(
    class(out[["0.5"]]),
    c("XY", "MULTILINESTRING", "sfg")
  )

  expect_equal(
    out[["1.5"]][[1]],
    cbind(
      c(3.75, 3.75, 4.00),
      c(3.00, 2.00, 1.75)
    )
  )

  expect_equal(
    class(out[["1.5"]]),
    c("XY", "MULTILINESTRING", "sfg")
  )
})



test_that("conversion of isobands to sfg", {
  #m <- matrix(c(0, 0, 0, 0, 0, 0,
  #              0, 2, 2, 2, 2, 0,
  #              0, 2, 0, 0, 2, 0,
  #              0, 2, 0, 0, 2, 0,
  #              0, 2, 2, 2, 2, 0,
  #              0, 0, 0, 0, 0, 0), 6, 6, byrow = TRUE)
  #bands <- isobands(1:6, 1:6, m, 0.5, 1.5)

  bands <- structure(
    list(
      `0.5:1.5` = list(
        x = c(5.00, 4.00, 3.00, 2.00, 1.25, 1.25, 1.25, 1.25, 2.00, 3.00,
              4.00, 5.00, 5.75, 5.75, 5.75, 5.75, 5.25, 5.25, 5.25, 5.25,
              5.00, 4.00, 3.00, 2.00, 1.75, 1.75, 1.75, 1.75, 2.00, 3.00,
              4.00, 5.00, 4.25, 4.25, 4.00, 3.00, 2.75, 2.75, 3.00, 4.00,
              4.75, 4.00, 3.00, 2.25, 2.25, 3.00, 4.00, 4.75),
        y = c(5.75, 5.75, 5.75, 5.75, 5.00, 4.00, 3.00, 2.00, 1.25, 1.25,
              1.25, 1.25, 2.00, 3.00, 4.00, 5.00, 5.00, 4.00, 3.00, 2.00,
              1.75, 1.75, 1.75, 1.75, 2.00, 3.00, 4.00, 5.00, 5.25, 5.25,
              5.25, 5.25, 4.00, 3.00, 2.75, 2.75, 3.00, 4.00, 4.25, 4.25,
              4.00, 4.75, 4.75, 4.00, 3.00, 2.25, 2.25, 3.00),
        id = c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
               1, 1, 1, 1, 1, 1, 2, 2, 2, 2,
               2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
               2, 2, 3, 3, 3, 3, 3, 3, 3, 3,
               4, 4, 4, 4, 4, 4, 4, 4)
      )
    ),
    class = c("isobands", "iso")
  )

  out <- iso_to_sfg(bands)

  expect_equal(
    out[["0.5:1.5"]][[1]][[1]],
    cbind(
      c(5.00, 4.00, 3.00, 2.00, 1.25, 1.25, 1.25, 1.25, 2.00, 3.00,
        4.00, 5.00, 5.75, 5.75, 5.75, 5.75, 5.00),
      c(5.75, 5.75, 5.75, 5.75, 5.00, 4.00, 3.00, 2.00, 1.25, 1.25,
        1.25, 1.25, 2.00, 3.00, 4.00, 5.00, 5.75)
    )
  )

  expect_equal(
    out[["0.5:1.5"]][[1]][[2]],
    cbind(
      c(5.25, 5.00, 4.00, 3.00, 2.00, 1.75, 1.75, 1.75, 1.75, 2.00,
        3.00, 4.00, 5.00, 5.25, 5.25, 5.25, 5.25),
      c(5.00, 5.25, 5.25, 5.25, 5.25, 5.00, 4.00, 3.00, 2.00, 1.75,
        1.75, 1.75, 1.75, 2.00, 3.00, 4.00, 5.00)
      )
  )

  expect_equal(
    out[["0.5:1.5"]][[2]][[1]],
    cbind(
      c(4.75, 4.00, 3.00, 2.25, 2.25, 3.00, 4.00, 4.75, 4.75),
      c(4.00, 4.75, 4.75, 4.00, 3.00, 2.25, 2.25, 3.00, 4.00)
    )
  )

  expect_equal(
    out[["0.5:1.5"]][[2]][[2]],
    cbind(
      c(4.25, 4.00, 3.00, 2.75, 2.75, 3.00, 4.00, 4.25, 4.25),
      c(4.00, 4.25, 4.25, 4.00, 3.00, 2.75, 2.75, 3.00, 4.00)
    )
  )

  expect_equal(
    class(out[["0.5:1.5"]]),
    c("XY", "MULTIPOLYGON", "sfg")
  )
})
