% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso8601totime.R
\name{iso8601totime}
\alias{iso8601totime}
\title{Convert time in ISO8601 format into R POSIXct object}
\usage{
iso8601totime(x)
}
\arguments{
\item{x}{character vector of time strings}
}
\value{
Returns a \code{Time} object, which is a subclass of \code{\link{POSIXct}}
object.  Time is represented as a time on 1970-01-01. The only difference
between the \code{Time} object and the \code{POSIXct} object is the
formatting, which leaves out the date part.
}
\description{
Convert time in ISO8601 format into R POSIXct object
}
\details{
Times are acceptes in any of the formats supported by ISO8601.
}
\examples{
iso8601totime(c("12:30:12", "T12", "T000910"))

iso8601totime("T16:15:14")
iso8601totime("T16:15:14,00")
iso8601totime("T16:15:14.00")
iso8601totime("T161514")
iso8601totime("T161514.00")
iso8601totime("T161514,00")
iso8601totime("T16:15:14,00")
iso8601totime("T16:15:14.00")
iso8601totime("T161514.00")
iso8601totime("T161514,00")
iso8601totime("T16:15.24")
iso8601totime("T16:15,24")
iso8601totime("T1615.24")
iso8601totime("T1615,24")
iso8601totime("T16.2539")
iso8601totime("T16,2539")

# T can be omitted
iso8601totime("16:15:14")
iso8601totime("16:15:14,00")
iso8601totime("16:15:14.00")
iso8601totime("16:15:14,00")
iso8601totime("16:15:14.00")
iso8601totime("16:15.24")
iso8601totime("16:15,24")
iso8601totime("161514")
iso8601totime("161514,00")
iso8601totime("161514.00")
iso8601totime("1615")
iso8601totime("1615")
iso8601totime("1615.24")
iso8601totime("1615,24")

}
