% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isnilmm.R
\name{isnilmm}
\alias{isnilmm}
\title{Function for ISNI computation when the outcome follows LMM.}
\usage{
isnilmm(ymfix, ymran, gmodel, predprobobs = NULL, misni = FALSE, alldata)
}
\arguments{
\item{ymfix}{an object of class "formula": a two-sided linear formula description of the fixed-effects part of the model to be fitted for the outcome}

\item{ymran}{an object of class "formula": an one-sided linear formula description of the random-effects part of the model to be fitted for the outcome}

\item{gmodel}{an object of class "formula": a symbolic description of the selection model to be fitted for the missingness indictor g}

\item{predprobobs}{Null if using buil-in multinomial transitional logistic model to obtain predicted probabilities of being observed;
otherwise user supply a vector of these probabilities for all the observations in alldata.}

\item{misni}{FALSE if using the default approach to computing ISNI with a scalar nonignorability parameter; 
TRUE when computing ISNI with multiple nonignorability parameters.}

\item{alldata}{the name of data frame containing all the variables in the model and all the observations including those intended to be collected but became missing.}
}
\description{
Calculate the ISNI when the regression outcome is subject to missingness and follows linear mixed-effects models (LMMs)
}
\examples{

data(qolef)
qolef$t12<-qolef$t1*qolef$group
qolef$t32<-qolef$t3*qolef$group
qolef$t62<-qolef$t6*qolef$group
ymfix=y~   t1+t3+t6 + group  + t12 + t32+t62 + perf + sever
gmodel=factor(g)~ group+factor(time)+yp+perf+sever
ymran=~1|id

##Random intercept model
result=isnilmm(ymfix,ymran, gmodel, alldata=qolef)
summary(result)

}
