% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3methods_islasso.R
\name{plot.islasso}
\alias{plot.islasso}
\title{Diagnostic Plots for islasso Models}
\usage{
\method{plot}{islasso}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"islasso"}, typically created via \code{\link{islasso}}.}

\item{...}{Additional graphical parameters passed to the underlying \code{plot()} functions.}
}
\description{
Produces standard diagnostic plots for a fitted \code{\link{islasso}} model to assess residuals,
model fit, and variance structure.
}
\details{
Generates a 2x2 grid of diagnostic plots:
\itemize{
  \item Top-left: Deviance residuals vs fitted values.
  \item Top-right: Normal Q-Q plot of standardized deviance residuals (red line = reference).
  \item Bottom-left: Squared standardized Pearson residuals vs fitted values.
  \item Bottom-right: Working response vector vs linear predictor.
}

These plots help assess the assumptions of linearity, homoscedasticity, and residual normality in penalized regression.
}
\examples{
\dontrun{
  set.seed(1)
  n <- 100; p <- 100
  beta <- c(runif(20, -3, 3), rep(0, p - 20))
  sim <- simulXy(n = n, p = p, beta = beta, seed = 1, family = gaussian())
  fit <- islasso(y ~ ., data = sim$data, family = gaussian(), lambda = 2)
  plot(fit)
}

}
\seealso{
\code{\link{islasso}}, \code{\link{summary.islasso}}, \code{\link{residuals.islasso}},
\code{\link{logLik.islasso}}, \code{\link{predict.islasso}}, \code{\link{deviance.islasso}}
}
\author{
Gianluca Sottile \email{gianluca.sottile@unipa.it}
}
