% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint_and_auxiliary.R
\name{confint.islasso}
\alias{confint.islasso}
\alias{print.confint.islasso}
\alias{plot.confint.islasso}
\title{confint method for \code{islasso} objects}
\usage{
\method{confint}{islasso}(object, parm, level = 0.95, type.ci = "wald", trace = TRUE, ...)
}
\arguments{
\item{object}{A fitted model object of class \code{"islasso"}.}

\item{parm}{A specification of which parameters are to be given confidence intervals, either a vector of numbers or a vector of names. If missing, all parameters are considered.}

\item{level}{The confidence level required.}

\item{type.ci}{Character. Only Wald-type confidence intervals are implemented yet! Set \code{type.ci = "wald"} to use estimates and standard errors to build the confidence interval.}

\item{trace}{Logical. If \code{TRUE} (default), a bar shows the iterations status.}

\item{...}{Additional arguments for methods.}
}
\description{
Computes confidence intervals for \code{islasso} objects using a Wald-type approach.
}
\details{
confint method for islasso objects
}
\examples{
n <- 100; p <- 100; p1 <- 10
beta.veri <- sort(round(c(seq(0.5, 3, length.out = p1 / 2),
                          seq(-1, -2, length.out = p1 / 2)), 2))
beta <- c(beta.veri, rep(0, p - p1))
sim <- simulXy(n = n, p = p, beta = beta, seed = 1, family = gaussian())
o <- islasso(y ~ ., data = sim$data, family = gaussian())

ci <- confint(o, type.ci = "wald", parm = 1:11)
ci
plot(ci)

}
\seealso{
\code{\link{islasso.fit}}, \code{\link{summary.islasso}}, \code{\link{residuals.islasso}}, \code{\link{logLik.islasso}}, \code{\link{predict.islasso}}, \code{\link{deviance.islasso}}
}
\author{
Maintainer: Gianluca Sottile <gianluca.sottile@unipa.it>
}
