% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_sim_helper_functions.R
\name{as.data.frame.cat_output}
\alias{as.data.frame.cat_output}
\title{Convert a \code{cat_output} object into a \code{data.frame}.}
\usage{
\method{as.data.frame}{cat_output}(x, row.names = NULL, optional = FALSE, ...)
}
\arguments{
\item{x}{An \code{cat_output} object}

\item{row.names}{\code{NULL} or a character vector giving the row names for
the data frame. Missing values are not allowed.}

\item{optional}{logical. If \code{TRUE}, setting row names and converting
column names}

\item{...}{additional arguments}
}
\value{
A data frame with the following columns:
  \describe{
    \item{true_ability}{True ability of the simulee}
    \item{est_before}{Ability estimate before administration of an item.}
    \item{se_before}{Standard error before administration of an item.}
    \item{testlet_id}{Administered testlet's ID.}
    \item{item_id}{Administered item's ID.}
    \item{resp}{Response to the item}
    \item{est_after}{Ability estimate after the administration of an item.}
    \item{se_after}{Standard error after administration of an item.}
  }
}
\description{
This function converts \code{cat_output} objects to a
  \code{data.frame} object.
}
\examples{
ip <- generate_ip(n = 40)
cd <- create_cat_design(ip = ip, next_item_rule = 'mfi',
                        termination_rule = 'max_item',
                        termination_par = list(max_item = 10))
cat_data <- cat_sim(true_ability = rnorm(1), cd = cd)
as.data.frame(cat_data)

}
\author{
Emre Gonulates
}
