% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QSPRpred.R
\docType{class}
\name{QSPRpred-class}
\alias{QSPRpred-class}
\alias{QSPRpred}
\title{QSPRpredictor class}
\description{
QSPR model construction using the Bayesian linear regression model.
}
\section{Fields}{

\describe{
\item{\code{ymin}}{vector representing minimal value in each target property}

\item{\code{ymax}}{vector representing maximum value in each target property}

\item{\code{descriptor}}{function transforming SMILES strings into numeric vector (matrix)}

\item{\code{fpnames}}{name of fingerprint used in a predictor}
}}

\section{Methods}{

\describe{
\item{\code{initialize(smis = NULL, y = NULL, v_ymin = NULL, v_ymax = NULL,
  v_descriptor = NULL, v_fpnames = NULL, w0 = NULL, V0_inv = NULL,
  a0 = NULL, b0 = NULL)}}{initialize the QSPR predictor}

\item{\code{inverse_predx(smis = NULL, temp = 1)}}{Inverse QSPR prediction of input SMILES strings smis for target property range}

\item{\code{qspr_predx(smis = NULL)}}{QSPR prediction of input SMILES strings smis}

\item{\code{set_targety(v_ymin, v_ymax)}}{set the target propety range}
}}

\examples{
data(qspr.data)
smis <- paste(qspr.data[,1])
ty <- qspr.data[,c(2,5)]
trainidx <- sample(1:nrow(qspr.data), 5000)
testidx <- (1:nrow(qspr.data))[-trainidx][1:100]

data(qsprpred_EG_5k) 
## same as run => qsprpred_EG_5k <- 

#-----arguments
#smis: SMILES string set (character vector) for training
#y: property sets (matrix) for training  
#v_ymin: minimum value of target properties
#v_ymax: maximum value of target properties
#v_descriptor: function transforming SMILES strings to feature matrix 
#v_fpnames: character vectors indicating finger print used in the descriptor
#w0: matrix representing prior mean of coeffients in linear regression model
#V0_inv: matrix representing the prior variance of coeffients in linear regression model
#a0: numeric value representing the location parameter in gamma prior 
#b0: numeric value representing the shape parameter in gamma prior 
#------

predictions <- qsprpred_EG_5k$qspr_predx(smis[testidx])  
par(mfrow=c(1,2))
plot(predictions[[1]][1,], ty[testidx,1])
plot(predictions[[1]][2,], ty[testidx,2])

#computing the probability which the properties of test structures is in the target range  
# set the minimal values in 2-d target properties
qsprpred_EG_5k$ymin <- c(100, 4)
# set the maximum values in 2-d target properties
qsprpred_EG_5k$ymin <- c(200, 5.5) 
# method inverse_predx returns the probability that input SMILES has property in target range
qsprpred_EG_5k$inverse_predx("c1ccccc1O")
}
