% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/web_url.R
\name{ipums_website}
\alias{ipums_website}
\title{Launch a browser window to an IPUMS metadata page}
\usage{
ipums_website(
  x,
  var = NULL,
  launch = TRUE,
  verbose = TRUE,
  homepage_if_missing = FALSE,
  project = deprecated(),
  var_label = deprecated()
)
}
\arguments{
\item{x}{An \code{\link{ipums_ddi}} object or the name of an IPUMS project.
See \code{\link[=ipums_data_collections]{ipums_data_collections()}} for supported projects.}

\item{var}{Name of the variable to load. If \code{NULL}, provides the URL to the
project's main data selection site.}

\item{launch}{If \code{TRUE}, launch a browser window to the metadata webpage.
Otherwise, return the URL for the webpage.}

\item{verbose}{If \code{TRUE}, produce warnings when invalid URL specifications
are detected.}

\item{homepage_if_missing}{If \code{TRUE}, return the IPUMS homepage if the
IPUMS project in \code{x} is not recognized.}

\item{project}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use \code{x} instead.}

\item{var_label}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Variable label for the
provided \code{var}. This is typically obtained from the input \code{ipums_ddi}
object and is unlikely to be needed.}
}
\value{
The URL to the IPUMS webpage for the indicated project and variable
(invisibly if \code{launch = TRUE})
}
\description{
Launch the documentation webpage for a given
IPUMS project and variable. The project can be provided in the form
of an \code{\link{ipums_ddi}} object or can be manually specified.

This provides access to more extensive variable metadata than may be
contained within an \code{ipums_ddi} object itself.

Note that some IPUMS projects (e.g. IPUMS NHGIS) do not have
variable-specific pages. In these cases, \code{ipums_website()} will launch the
project's main data selection page.
}
\details{
If \code{launch = TRUE}, you will need a valid registration for the specified
project to successfully launch the webpage.

Not all IPUMS variables are found at webpages that exactly match the variable
names that are included in completed extract files (and \code{ipums_ddi} objects).
Therefore, there may be some projects and variables for which
\code{ipums_website()} will launch the page for a different variable or an
invalid page.
}
\examples{
ddi <- read_ipums_ddi(ipums_example("cps_00157.xml"))

\dontrun{
# Launch webpage for particular variable
ipums_website(ddi, "MONTH")
}

# Can also specify an IPUMS project instead of an `ipums_ddi` object
ipums_website("IPUMS CPS", var = "RECTYPE", launch = FALSE)

# Shorthand project names from `ipums_data_collections()` are also accepted:
ipums_website("ipumsi", var = "YEAR", launch = FALSE)
}
